/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class Sequence {
    private File backup;
    private File file;

    public Sequence(File file) {
        this.file = file;
        this.backup = new File(file.getAbsolutePath() + ".backup");
    }

    public Sequence(String path) {
        this.file = new File(path);
        this.backup = new File(path + ".backup");
    }

    private long loadNext(File file) throws IOException {
        String line = "";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            line = reader.readLine();
            long next = Long.parseLong(line);
            reader.close();
            return next;
        }
        catch (NumberFormatException e) {
            throw new IOException("Illegal value on persistence file: " + line);
        }
        catch (FileNotFoundException e) {
            return 0L;
        }
    }

    private void saveNext(File file, long next) throws IOException {
        PrintWriter writer = new PrintWriter((Writer)new FileWriter(file, false), true);
        writer.println(next + 1L);
        writer.close();
    }

    public synchronized long getNext() throws IOException {
        long next = 0L;
        try {
            next = this.loadNext(this.file.exists() ? this.file : this.backup);
        }
        catch (IOException e) {
            next = this.loadNext(this.backup);
        }
        this.saveNext(this.backup, next);
        this.saveNext(this.file, next);
        return next;
    }
}

