/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.logger.controller;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import java.util.regex.Pattern;
import net.aihelp.core.util.logger.LoggerDBHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoggerDBController {
    private static final String TAG = LoggerDBController.class.getSimpleName();
    private static final Object syncLock = new Object();
    private static final int MAX_ROWS = 100;
    private final LoggerDBHelper loggerDBHelper = LoggerDBHelper.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int level, String message, String stacktrace, long timeStamp) {
        SQLiteDatabase db = null;
        Cursor allRowIdCursor = null;
        Object object = syncLock;
        synchronized (object) {
            try {
                db = this.loggerDBHelper.getWritableDatabase();
                db.beginTransaction();
                try {
                    allRowIdCursor = db.rawQuery("SELECT rowid FROM LOG_MESSAGES", null);
                    if (allRowIdCursor != null && allRowIdCursor.getCount() >= 100) {
                        allRowIdCursor.moveToFirst();
                        int firstRowId = allRowIdCursor.getInt(0);
                        db.delete("LOG_MESSAGES", "rowid = ?", new String[]{String.valueOf(firstRowId)});
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)("Error in rotation of logs + " + e.getMessage()));
                    db.delete("LOG_MESSAGES", (String)null, (String[])null);
                }
                db.insert("LOG_MESSAGES", (String)null, this.toContentValues(level, message, stacktrace, timeStamp));
                db.setTransactionSuccessful();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error inserting log : ", (Throwable)e);
            }
            finally {
                try {
                    if (db != null) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error inserting log inside finally block: ", (Throwable)e);
                }
                if (allRowIdCursor != null) {
                    allRowIdCursor.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONArray getCachedLogs() {
        Cursor cursor = null;
        Object object = syncLock;
        synchronized (object) {
            try {
                SQLiteDatabase db = this.loggerDBHelper.getReadableDatabase();
                cursor = db.rawQuery("SELECT * FROM LOG_MESSAGES", null);
                JSONArray jSONArray = this.fromCursor(cursor);
                return jSONArray;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error getting all log messages : ", (Throwable)e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return new JSONArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = syncLock;
        synchronized (object) {
            try {
                SQLiteDatabase db = this.loggerDBHelper.getWritableDatabase();
                db.execSQL("DELETE FROM LOG_MESSAGES");
            }
            catch (Exception var4) {
                Log.e((String)TAG, (String)"Error deleting all logs from db", (Throwable)var4);
            }
        }
    }

    private ContentValues toContentValues(int level, String message, String stacktrace, long timeStamp) {
        ContentValues values = new ContentValues();
        try {
            if (!TextUtils.isEmpty((CharSequence)message) && message.length() > 5000) {
                message = message.substring(0, 5000);
            }
            if (!TextUtils.isEmpty((CharSequence)stacktrace) && stacktrace.length() > 5000) {
                stacktrace = stacktrace.substring(0, 5000);
            }
            values.put("LEVEL", Integer.valueOf(level));
            values.put("TIMESTAMP", Long.valueOf(timeStamp));
            values.put("MESSAGE", message);
            values.put("STACKTRACE", stacktrace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    private JSONArray fromCursor(Cursor c) {
        JSONArray logArray = new JSONArray();
        try {
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    JSONObject jsonObject = new JSONObject();
                    String level = this.getLogLevel(c.getInt(c.getColumnIndex("LEVEL")));
                    String timestamp = c.getString(c.getColumnIndex("TIMESTAMP"));
                    String message = c.getString(c.getColumnIndex("MESSAGE"));
                    String stacktrace = c.getString(c.getColumnIndex("STACKTRACE"));
                    jsonObject.put("level", (Object)level);
                    jsonObject.put("timestamp", Pattern.matches("[1-9]*", timestamp) ? Long.parseLong(timestamp) : 0L);
                    jsonObject.put("message", (Object)message);
                    jsonObject.put("stacktrace", (Object)stacktrace);
                    logArray.put((Object)jsonObject);
                    c.moveToNext();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logArray;
    }

    public static LoggerDBController getInstance() {
        return LazyHolder.INSTANCE;
    }

    private String getLogLevel(int level) {
        switch (level) {
            case 1: {
                return "fatal";
            }
            case 2: {
                return "error";
            }
        }
        return "warn";
    }

    private LoggerDBController() {
    }

    private static final class LazyHolder {
        static final LoggerDBController INSTANCE = new LoggerDBController();

        private LazyHolder() {
        }
    }
}

