/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.permission;

import android.app.Activity;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.core.util.permission.PermissionHelper;

public class AIHelpPermissions {
    private Object object;
    private int requestCode = 0;
    private String permission;
    private PermissionHelper helper;
    private static AIHelpPermissions sInstance;

    private AIHelpPermissions() {
    }

    public void requestPermissions(Activity activity, String permission2, int requestCode) {
        this.setHost(activity).setRequestPermission(permission2).setRequestCode(requestCode).request();
    }

    public AIHelpPermissions setHost(Object object) {
        this.object = object;
        return this;
    }

    public AIHelpPermissions setRequestPermission(String permission2) {
        this.permission = permission2;
        return this;
    }

    public AIHelpPermissions setRequestCode(int requestCode) {
        this.requestCode = requestCode;
        return this;
    }

    public void request() {
        this.helper = PermissionHelper.getInstance(this.object, this.permission, this.requestCode);
        switch (this.helper.checkPermissionState()) {
            case AVAILABLE: {
                this.helper.invokePermissionCallback(Permission.Result.GRANTED);
                break;
            }
            case UNAVAILABLE: {
                this.helper.invokePermissionCallback(Permission.Result.NONE);
                break;
            }
            case RATIONAL: {
                this.helper.invokePermissionCallback(Permission.Result.RATIONAL);
                break;
            }
            case ASKABLE: {
                this.helper.requestPermission();
            }
        }
    }

    public void onRequestPermissionsResult(boolean isPermissionGranted) {
        if (this.helper != null) {
            this.helper.onRequestPermissionsResult(isPermissionGranted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AIHelpPermissions getInstance() {
        if (sInstance != null) return sInstance;
        Class<PermissionHelper> clazz = PermissionHelper.class;
        synchronized (PermissionHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AIHelpPermissions();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }
}

