/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.permission;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import java.lang.reflect.Method;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;

public class PermissionHelper
implements IPermissionCallback {
    private Object object;
    private int requestCode;
    private String permission;

    private PermissionHelper(Object object, String permission2, int requestCode) {
        this.object = object;
        this.permission = permission2;
        this.requestCode = requestCode;
    }

    public static PermissionHelper getInstance(Object object, String permission2, int requestCode) {
        if (object == null || permission2 == null || requestCode == 0) {
            throw new IllegalArgumentException("mObject == null || permission == null || requestCode == 0!");
        }
        return new PermissionHelper(object, permission2, requestCode);
    }

    void invokePermissionCallback(Permission.Result result) {
        Method[] methods;
        for (Method method : methods = this.object.getClass().getDeclaredMethods()) {
            Permission grantedMethod = method.getAnnotation(Permission.class);
            if (grantedMethod == null || this.requestCode != grantedMethod.requestCode()) continue;
            method.setAccessible(true);
            try {
                method.invoke(this.object, new Object[]{result, this});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isPermissionGranted() {
        if (this.getActivity() != null) {
            return ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)this.permission) == 0;
        }
        return false;
    }

    private Activity getActivity() {
        if (this.object instanceof Activity) {
            return (Activity)this.object;
        }
        if (this.object instanceof Fragment) {
            return ((Fragment)this.object).getActivity();
        }
        return null;
    }

    void onRequestPermissionsResult(boolean isPermissionGranted) {
        if (isPermissionGranted) {
            this.invokePermissionCallback(Permission.Result.GRANTED);
        } else if (this.shouldShowRequestPermissionRationale()) {
            this.invokePermissionCallback(Permission.Result.DENIED);
        } else {
            this.invokePermissionCallback(Permission.Result.GO_SETTING);
        }
    }

    Permission.State checkPermissionState() {
        Permission.State permissionState;
        Context context = AIHelpContext.getInstance().getContext();
        if (this.isPermissionGranted() || Build.VERSION.SDK_INT < 23) {
            permissionState = Permission.State.AVAILABLE;
        } else {
            boolean hasPermissionInManifest = PermissionHelper.hasPermissionInManifest(context, this.permission);
            if (hasPermissionInManifest) {
                permissionState = Permission.State.ASKABLE;
                if (this.shouldShowRequestPermissionRationale()) {
                    permissionState = Permission.State.RATIONAL;
                }
            } else {
                permissionState = Permission.State.UNAVAILABLE;
            }
        }
        return permissionState;
    }

    void requestPermission() {
        Fragment fragment;
        if (this.object instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)this.object), (String[])new String[]{this.permission}, (int)this.requestCode);
        } else if (this.object instanceof Fragment && !(fragment = (Fragment)this.object).isDetached()) {
            fragment.requestPermissions(new String[]{this.permission}, this.requestCode);
        }
    }

    private boolean shouldShowRequestPermissionRationale() {
        Fragment fragment;
        if (this.object instanceof Activity) {
            if (Build.VERSION.SDK_INT >= 23) {
                return ((Activity)this.object).shouldShowRequestPermissionRationale(this.permission);
            }
        } else if (this.object instanceof Fragment && !(fragment = (Fragment)this.object).isDetached()) {
            return fragment.shouldShowRequestPermissionRationale(this.permission);
        }
        return false;
    }

    private static boolean hasPermissionInManifest(Context context, String permission2) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            if (info.requestedPermissions != null) {
                for (String p : info.requestedPermissions) {
                    if (!p.equals(permission2)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean hasReadPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            return PermissionHelper.hasPermissionInManifest(context, "android.permission.READ_EXTERNAL_STORAGE");
        }
        return true;
    }

    private void showSettingsPage() {
        Activity activity = this.getActivity();
        if (activity != null) {
            try {
                Intent settingsIntent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                settingsIntent.addCategory("android.intent.category.DEFAULT");
                String packageName = activity.getPackageName();
                settingsIntent.setData(Uri.parse((String)("package:" + packageName)));
                activity.startActivity(settingsIntent);
            }
            catch (ActivityNotFoundException var3) {
                Intent i = new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS");
                i.addCategory("android.intent.category.DEFAULT");
                activity.startActivity(i);
            }
        }
    }

    @Override
    public void onPermissionDenied() {
    }

    @Override
    public void onPermissionRational() {
        this.requestPermission();
    }

    @Override
    public void onPermissionIgnored() {
        this.showSettingsPage();
    }
}

