/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.local;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.core.mvp.AbsRepository;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.model.faq.FaqListEntity;
import org.json.JSONArray;
import org.json.JSONObject;

public class FaqRepository
extends AbsRepository {
    public FaqRepository(Context context) {
        super(context);
    }

    public boolean shouldShowQuestionFooter(String faqId) {
        return FaqHelper.INSTANCE.shouldShowQuestionFooter(faqId);
    }

    public boolean checkWhetherHasSubSection(String sectionId) {
        return FaqHelper.INSTANCE.hasSubsections(sectionId);
    }

    public ArrayList<FaqListEntity> getMatchedFaqList(String query) {
        JSONArray sourceNotifications = FaqHelper.INSTANCE.getRawNotification();
        JSONArray sourceHotTopics = FaqHelper.INSTANCE.getRawHotTopics();
        JSONArray sourceFaqs = FaqHelper.INSTANCE.getRawFlatFaqArray();
        ArrayList<FaqListEntity> matchedFaqList = new ArrayList<FaqListEntity>();
        StringBuilder addedFaqs = new StringBuilder();
        matchedFaqList.addAll(this.iteratorFaqList(sourceNotifications, query, addedFaqs));
        matchedFaqList.addAll(this.iteratorFaqList(sourceHotTopics, query, addedFaqs));
        matchedFaqList.addAll(this.iteratorFaqList(sourceFaqs, query, addedFaqs));
        return matchedFaqList;
    }

    public List<FaqListEntity> iteratorFaqList(JSONArray sourceArray, String query, StringBuilder addedFaqs) {
        ArrayList<FaqListEntity> titleMatchedList = new ArrayList<FaqListEntity>();
        ArrayList<FaqListEntity> contentMatchedList = new ArrayList<FaqListEntity>();
        if (sourceArray != null && sourceArray.length() > 0) {
            for (int i = 0; i < sourceArray.length(); ++i) {
                FaqListEntity matched;
                JSONObject faq = JsonHelper.getJsonObject(sourceArray, i);
                boolean isHidden = faq.optBoolean("isHidden");
                String faqMainId = faq.optString("kmMainid");
                String faqTitle = faq.optString("question");
                String faqContent = faq.optString("noHtmlContent");
                if (!isHidden && faqTitle.toLowerCase().contains(query.toLowerCase())) {
                    if (addedFaqs.toString().contains(faqMainId)) continue;
                    matched = new FaqListEntity(4, faqMainId, faqTitle, query);
                    titleMatchedList.add(matched);
                    addedFaqs.append(String.format("%s,", faqMainId));
                    continue;
                }
                if (isHidden || !faqContent.toLowerCase().contains(query.toLowerCase()) || addedFaqs.toString().contains(faqMainId)) continue;
                matched = new FaqListEntity(4, faqMainId, faqTitle, query);
                contentMatchedList.add(matched);
                addedFaqs.append(String.format("%s,", faqMainId));
            }
        }
        ArrayList<FaqListEntity> matchedFaqList = new ArrayList<FaqListEntity>();
        matchedFaqList.addAll(contentMatchedList);
        matchedFaqList.addAll(0, titleMatchedList);
        return matchedFaqList;
    }
}

