/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import java.io.ByteArrayInputStream;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.data.localize.config.BusinessLogicHelper;
import net.aihelp.data.localize.config.StyleSheetHelper;
import net.aihelp.data.localize.config.TextHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.localize.data.LocaleStringHelper;
import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.ui.helper.ElvaBotHelper;
import net.aihelp.utils.FileUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LocalizeHelper {
    public static final int FLAG_FAQ_SECTION = 1001;
    public static final int FLAG_OP = 1002;
    public static final int FLAG_STORY = 1003;
    public static final int FLAG_LOCALE = 1005;
    public static final int FLAG_STYLE_SHEET = 1006;
    public static final int FLAG_BUSINESS_LOGIC = 1007;
    public static final int FLAG_FEEDBACK_OPINION = 1008;
    public static final int FLAG_FAQ_HOT_TOPIC = 1009;
    public static final int FLAG_PROCESS = 1010;
    public static final int FLAG_TEXT = 1011;

    public static void resetLocalizeData() {
        FaqHelper.INSTANCE.reset();
        OperateHelper.INSTANCE.reset();
        LocaleStringHelper.INSTANCE.reset();
        TextHelper.INSTANCE.reset();
    }

    public static void goFetchLocalizeData(Context context) {
        LocalizeHelper.goFetchElvaBotData(context);
        if (Const.TOGGLE_LOCALIZE_VIA_INIT) {
            LocalizeHelper.getLocalizeDataFromUrl(1001);
        } else if (LocalizeUtil.isAlreadyLocalized(1001) && !LocalizeUtil.isFallbackUrl(1001, LocalizeUtil.getUrl(1001))) {
            FaqHelper.INSTANCE.prepareDataSource();
        }
        LocalizeHelper.getLocalizeDataFromUrl(1002);
        LocalizeHelper.getLocalizeDataFromUrl(1005);
        LocalizeHelper.getLocalizeDataFromUrl(1006);
        LocalizeHelper.getLocalizeDataFromUrl(1007);
        LocalizeHelper.getLocalizeDataFromUrl(1009);
        LocalizeHelper.getLocalizeDataFromUrl(1011);
    }

    public static void goFetchElvaBotData(final Context context) {
        AIHelpRequest.getInstance().requestDownloadFile(1003, new ReqCallback<String>(){

            @Override
            public void onAsyncReqSuccess(String result) {
                ElvaBotHelper.initBot(context);
            }
        });
    }

    public static void getLocalizeDataFromUrl(final int mode) {
        if (mode == 1002) {
            OperateHelper.INSTANCE.prepareHistoricDataSource();
        }
        if (mode == 1001 && FaqHelper.isFaqDataAlreadyPrepared()) {
            return;
        }
        AIHelpRequest.getInstance().requestDownloadFile(mode, new ReqCallback<String>(){

            @Override
            public void onAsyncReqSuccess(String result) {
                switch (mode) {
                    case 1001: {
                        FaqHelper.INSTANCE.prepareDataSource();
                        break;
                    }
                    case 1002: {
                        OperateHelper.INSTANCE.prepareDataSource();
                        break;
                    }
                    case 1005: {
                        LocaleStringHelper.INSTANCE.prepareDataSource();
                        break;
                    }
                    case 1006: {
                        StyleSheetHelper.INSTANCE.prepareDataSource();
                        break;
                    }
                    case 1007: {
                        BusinessLogicHelper.INSTANCE.prepareDataSource();
                        break;
                    }
                    case 1009: {
                        FaqHelper.INSTANCE.prepareNotificationAndHotTopics();
                        break;
                    }
                    case 1011: {
                        TextHelper.INSTANCE.prepareDataSource();
                    }
                }
            }

            @Override
            public void onAsyncFailure(String url, int errorCode, String errorMsg) {
                if (mode == 1001 || mode == 1002) {
                    LocalizeHelper.getDataAfterLocalizeFailed(mode);
                }
            }
        });
    }

    private static void getDataAfterLocalizeFailed(final int mode) {
        String url = mode == 1001 ? API.FAQ_URL : API.OP_URL;
        AIHelpRequest.getInstance().requestGetByAsync(url, null, new ReqCallback<String>(){

            @Override
            public void onAsyncReqSuccess(String str) {
                try {
                    boolean success;
                    if (!TextUtils.isEmpty((CharSequence)str) && (success = FileUtil.writeFileToDisk(new ByteArrayInputStream(str.getBytes()), LocalizeUtil.getFileLocation(mode)))) {
                        if (mode == 1001) {
                            FaqHelper.INSTANCE.prepareDataSource();
                        } else {
                            OperateHelper.INSTANCE.prepareDataSource();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

