/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.config;

import android.text.TextUtils;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.BusinessLogicEntity;
import net.aihelp.utils.FileUtil;

public enum BusinessLogicHelper {
    INSTANCE;


    public void prepareDataSource() {
        try {
            BusinessLogicEntity logicEntity;
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(1007));
            if (!TextUtils.isEmpty((CharSequence)content) && (logicEntity = JsonHelper.toJavaObject(content, BusinessLogicEntity.class)) != null) {
                this.prepareCommonConfig(logicEntity.getGeneral());
                this.prepareHelpCenterConfig(logicEntity.getHelp());
                this.prepareCustomerServiceConfig(logicEntity.getOnLine());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareCommonConfig(BusinessLogicEntity.GeneralEntity entity) {
        boolean bl = CustomConfig.CommonSetting.isBackgroundRenderedWithImage = entity.getBgOptions() == 2;
        if (entity.getFaqEvaluation() != null) {
            CustomConfig.CommonSetting.isEvaluationForBotEnable = entity.getFaqEvaluation().isOnlineValid();
            CustomConfig.CommonSetting.isEvaluationForAnswerPageEnable = entity.getFaqEvaluation().isFaqDetailValid();
            CustomConfig.CommonSetting.isFaqUnhelpfulFeedbackEnable = entity.getFaqEvaluation().isSuggestionValid();
            CustomConfig.CommonSetting.isEvaluationForOperationEnable = entity.getFaqEvaluation().isOperateDetailValid();
        }
        CustomConfig.CommonSetting.screenOrientation = entity.getDirection();
        CustomConfig.CommonSetting.privacyControlData = entity.getInformation();
    }

    private void prepareHelpCenterConfig(BusinessLogicEntity.HelpEntity entity) {
        CustomConfig.HelpCenter.isFaqTitleIconVisible = entity.getIsTitleIconValid();
        CustomConfig.HelpCenter.isFaqSearchVisible = entity.getIsSearchValid();
        if (entity.getNoticeBar() != null) {
            CustomConfig.HelpCenter.isFaqNotificationVisible = entity.getNoticeBar().getIsNoticeValid();
            CustomConfig.HelpCenter.isFaqNotificationIconVisible = entity.getNoticeBar().getIsNoticeIconValid();
            CustomConfig.HelpCenter.faqNotificationInterval = entity.getNoticeBar().getIntervals();
        }
        if (entity.getFaqList() != null) {
            CustomConfig.HelpCenter.isFaqHotTopicVisible = entity.getFaqList().getIsFaqListValid();
            CustomConfig.HelpCenter.isFaqHotTopicTitleVisible = entity.getFaqList().getIsTitleValid();
            CustomConfig.HelpCenter.isFaqHotTopicTitleIconVisible = entity.getFaqList().getIsTitleIconValid();
            CustomConfig.HelpCenter.isFaqHotTopicItemIconVisible = entity.getFaqList().getIsFaqIconValid();
        }
        if (entity.getFaqSectionList() != null) {
            CustomConfig.HelpCenter.isFaqSectionTitleVisible = entity.getFaqSectionList().getIsTitleValid();
            CustomConfig.HelpCenter.isFaqSectionTitleIconVisible = entity.getFaqSectionList().getIsTitleIconValid();
            CustomConfig.HelpCenter.isFaqSectionItemIconVisible = entity.getFaqSectionList().getIsFaqIconValid();
            CustomConfig.HelpCenter.isFaqSectionDisplayAsList = entity.getFaqSectionList().getArrangement() == 1;
        }
    }

    private void prepareCustomerServiceConfig(BusinessLogicEntity.OnLineEntity entity) {
        CustomConfig.CustomerService.isCsTitleIconVisible = entity.getIsNavBarTitleIconValid();
        CustomConfig.CustomerService.isPortraitVisible = entity.getIsHeadValid();
        CustomConfig.CustomerService.isNicknameVisible = entity.getIsExternalName();
        CustomConfig.CustomerService.isMessageTimestampVisible = entity.getIsSendTime();
        if (entity.getHistoryTicket() != null) {
            CustomConfig.CustomerService.isHistoryChatEnable = entity.getHistoryTicket().getIsValid();
        }
        if (entity.getSatisfied() != null) {
            CustomConfig.CustomerService.isTicketRatingEnable = entity.getSatisfied().isValid();
            CustomConfig.CustomerService.isEvaluateBadServiceEnable = entity.getSatisfied().isFeedback();
            CustomConfig.CustomerService.csEvaluateMaxCount = entity.getSatisfied().getFeedbackMax();
        }
    }
}

