/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.config;

import android.text.TextUtils;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.StyleSheetEntity;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.FileUtil;

public enum StyleSheetHelper {
    INSTANCE;


    public void prepareDataSource() {
        try {
            StyleSheetEntity styleEntity;
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(1006));
            if (!TextUtils.isEmpty((CharSequence)content) && (styleEntity = JsonHelper.toJavaObject(content, StyleSheetEntity.class)) != null) {
                this.prepareCommonConfig(styleEntity.getGeneral());
                this.prepareHelpCenterConfig(styleEntity.getHelp());
                this.prepareCustomerServiceConfig(styleEntity.getOnLine());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareCustomerServiceConfig(StyleSheetEntity.OnLineEntity entity) {
        CustomConfig.CustomerService.csNavigationBarTitleIcon = this.getCorrectedUrl(entity.getNavBar());
        CustomConfig.CustomerService.csBotSupportPortrait = this.getCorrectedUrl(entity.getRobotImgUrl());
        CustomConfig.CustomerService.csManualSupportPortrait = this.getCorrectedUrl(entity.getCustomerImgUrl());
        CustomConfig.CustomerService.csUserPortrait = this.getCorrectedUrl(entity.getUserImgUrl());
    }

    private void prepareHelpCenterConfig(StyleSheetEntity.HelpEntity entity) {
        CustomConfig.HelpCenter.faqNavigationBarTitleIcon = this.getCorrectedUrl(entity.getNavBar());
        CustomConfig.HelpCenter.faqNotificationIcon = this.getCorrectedUrl(entity.getNoticeBar());
        CustomConfig.HelpCenter.faqHotTopicTitleIcon = this.getCorrectedUrl(entity.getFaqList());
        CustomConfig.HelpCenter.faqSectionTitleIcon = this.getCorrectedUrl(entity.getFaqSectionList());
    }

    private void prepareCommonConfig(StyleSheetEntity.GeneralEntity entity) {
        if (entity.getNavBar() != null) {
            CustomConfig.CommonSetting.navigationBarBackground = entity.getNavBar().getColor();
            CustomConfig.CommonSetting.navigationBarAlpha = entity.getNavBar().getTransparency();
        }
        CustomConfig.CommonSetting.backgroundColorForAll = entity.getVertical();
        CustomConfig.CommonSetting.backgroundImageForPortrait = this.getCorrectedUrl(entity.getVerticalImgUrl());
        CustomConfig.CommonSetting.backgroundImageForLandscape = this.getCorrectedUrl(entity.getHorizontalImgUrl());
        if (entity.getFrontColor() != null) {
            CustomConfig.CommonSetting.upperBackgroundColor = entity.getFrontColor().getColor();
            CustomConfig.CommonSetting.upperBackgroundAlpha = entity.getFrontColor().getTransparency();
        }
        CustomConfig.CommonSetting.textColor = entity.getTextColor();
        CustomConfig.CommonSetting.highlightedColor = entity.getHighlightColor();
        CustomConfig.CommonSetting.interactElementTextColor = entity.getButtonColor();
    }

    private String getCorrectedUrl(String originUrl) {
        return DomainSupportHelper.getAdjustedUrl(originUrl);
    }
}

