/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.util;

import android.text.TextUtils;
import java.io.File;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.TLog;

public class LocalizeUtil {
    public static boolean isAIMLLocalized() {
        return LocalizeUtil.isAlreadyLocalized(1003);
    }

    public static boolean isFallbackUrl(int mode, String url) {
        return (mode == 1001 || mode == 1002) && url.endsWith(String.format("%s-from-api.json", Const.CORRECT_LANGUAGE));
    }

    public static String getFileLocation(int mode, String fileName) {
        File dirFile;
        String dirPath = "";
        File filesDir = AIHelpContext.getInstance().getContext().getFilesDir();
        if (filesDir != null && !(dirFile = new File(dirPath = filesDir.getAbsolutePath() + "/AIHelp" + LocalizeUtil.getFolderName(mode) + Const.CORRECT_LANGUAGE)).exists() && dirFile.mkdirs()) {
            return dirFile.getAbsolutePath() + File.separator + fileName;
        }
        return dirPath + File.separator + fileName;
    }

    public static String getFileLocation(int mode) {
        return LocalizeUtil.getFileLocation(mode, LocalizeUtil.getFileName(mode));
    }

    public static String getUrl(int mode) {
        switch (mode) {
            case 1005: {
                return API.LOCALE_FILE_URL;
            }
            case 1006: {
                return API.CONFIG_STYLE_SHEET_URL;
            }
            case 1007: {
                return API.CONFIG_BUSINESS_LOGIC_URL;
            }
            case 1008: {
                return API.CONFIG_OPINION_URL;
            }
            case 1009: {
                return API.CONFIG_FAQ_HOT_TOPIC_URL;
            }
            case 1010: {
                return API.CONFIG_PROCESS_URL;
            }
            case 1011: {
                return API.CONFIG_TEXT_URL;
            }
        }
        return API.CDN_URL + LocalizeUtil.getFolderName(mode) + Const.APP_ID + File.separator + LocalizeUtil.getFileName(mode);
    }

    public static boolean isAlreadyLocalized(int mode) {
        try {
            File[] files;
            String path = LocalizeUtil.getFileLocation(mode);
            File file = new File(path);
            if (file.exists()) {
                return true;
            }
            File parentFile = file.getParentFile();
            if (parentFile != null && (files = parentFile.listFiles()) != null && files.length > 0) {
                for (File oldFile : files) {
                    if (!oldFile.delete()) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            TLog.e("LocalizeHelper check localize status failed.");
        }
        return false;
    }

    public static String getFolderName(int mode) {
        String middle = "";
        switch (mode) {
            case 1003: {
                middle = "/AIML/";
                break;
            }
            case 1001: {
                middle = "/FAQ/";
                break;
            }
            case 1002: {
                middle = "/OPerMode/";
                break;
            }
            case 1005: {
                middle = "/locale/";
                break;
            }
            case 1006: {
                middle = "/stylesheet/";
                break;
            }
            case 1007: {
                middle = "/toggle/";
                break;
            }
            case 1008: {
                middle = "/opinion/";
                break;
            }
            case 1009: {
                middle = "/hotTopic/";
                break;
            }
            case 1010: {
                middle = "/process/";
                break;
            }
            case 1011: {
                middle = "/text/";
            }
        }
        return middle;
    }

    public static String getFileName(int mode) {
        String fileName = "";
        switch (mode) {
            case 1003: {
                fileName = Const.STORY_FILE;
                break;
            }
            case 1001: {
                fileName = LocalizeUtil.getLocalizeFileName(Const.FAQ_FILE);
                break;
            }
            case 1002: {
                fileName = LocalizeUtil.getLocalizeFileName(Const.OP_FILE);
                break;
            }
            case 1005: {
                fileName = LocalizeUtil.getLocalizeFileName(API.LOCALE_FILE_URL);
                break;
            }
            case 1006: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_STYLE_SHEET_URL);
                break;
            }
            case 1007: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_BUSINESS_LOGIC_URL);
                break;
            }
            case 1008: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_OPINION_URL);
                break;
            }
            case 1009: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_FAQ_HOT_TOPIC_URL);
                break;
            }
            case 1010: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_PROCESS_URL);
                break;
            }
            case 1011: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_TEXT_URL);
            }
        }
        return fileName;
    }

    private static String getLocalizeFileName(String url) {
        String[] split;
        if (!TextUtils.isEmpty((CharSequence)url) && (split = url.split("/")).length > 0) {
            return split[split.length - 1];
        }
        return String.format("%s-from-api.json", Const.CORRECT_LANGUAGE);
    }
}

