/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import android.content.Context;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import java.io.File;
import java.util.List;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.http.callback.UploadCallback;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.data.logic.MqttPresenter;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.init.UploadEntity;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.helper.ConversationHelper;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConversationPresenter
extends MqttPresenter<ConversationFragment, IRepository> {
    public ConversationPresenter(Context context) {
        super(context);
    }

    public void uploadImage(File file, final long timeStamp) {
        if (!this.validateNetwork()) {
            ((ConversationFragment)this.mView).showError(ResResolver.getString("aihelp_network_no_connect"));
            ((ConversationFragment)this.mView).updateMsgStatus(false, timeStamp);
            return;
        }
        AIHelpRequest.getInstance().requestUpLoadFile(API.UPLOAD_URL, file, new UploadCallback<UploadEntity.ImageResult>(){

            @Override
            public void onReqSuccess(UploadEntity.ImageResult result) {
                if (result != null) {
                    ConversationPresenter.this.chatWithSupport(timeStamp, result.getUrl());
                }
            }
        });
    }

    public void uploadVideo(File file, final long timeStamp) {
        if (!this.validateNetwork()) {
            ((ConversationFragment)this.mView).showError(ResResolver.getString("aihelp_network_no_connect"));
            ((ConversationFragment)this.mView).updateMsgStatus(false, timeStamp);
            return;
        }
        AIHelpRequest.getInstance().requestUpLoadFile(API.UPLOAD_VIDEO_URL, file, new UploadCallback<UploadEntity.VideoResult>(){

            @Override
            public void onReqSuccess(UploadEntity.VideoResult result) {
                if (result != null) {
                    ConversationPresenter.this.chatWithSupport(timeStamp, result.getData());
                }
            }
        });
    }

    public void prepareMqttConnection(IMqttCallback callback) {
        callback.showMqttLoading();
        if (this.isNetworkAvailable()) {
            callback.updateHostView((Fragment)this.mView);
            AIHelpMqtt.getInstance().prepare(2, callback);
        } else {
            ((ConversationFragment)this.mView).showError(ResResolver.getString("aihelp_network_no_connect"));
        }
        this.goFetchUnreadMessageCount();
    }

    public void chatWithSupport(long timeStamp, String userSay) {
        try {
            JSONObject chatParams = new JSONObject();
            chatParams.put("msg", (Object)userSay);
            chatParams.put("timeStamp", timeStamp);
            chatParams.put("chatTags", (Object)"");
            chatParams.put("imgFlag", (Object)"0");
            this.mqtt("chat.private", chatParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void evaluateSupport(int rate, String inputSuggestion, JSONArray selectedItems) {
        try {
            JSONObject evaluateParams = new JSONObject();
            evaluateParams.put("star_index", rate);
            evaluateParams.put("else_msg", (Object)inputSuggestion);
            evaluateParams.put("choose_list", (Object)selectedItems);
            this.mqtt("alice.chat.evaluate", evaluateParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveInputDraftIfNeeded(String inputContent) {
        if (!TextUtils.isEmpty((CharSequence)inputContent)) {
            this.mSp.put("sp_input_draft", inputContent);
        }
    }

    public void getLastConversation(int currentPage) {
        if (!this.isNetworkAvailable()) {
            ToastUtil.INSTANCE.makeRawToast(this.mContext, ResResolver.getString("aihelp_network_no_connect"));
            ((ConversationFragment)this.mView).onLastConversationRetrieved(null);
            return;
        }
        try {
            JSONObject hashMap = new JSONObject();
            hashMap.put("userId", (Object)UserProfile.USER_ID);
            hashMap.put("deviceId", (Object)DeviceUuidFactory.id(this.mContext));
            hashMap.put("index", (Object)String.valueOf(currentPage));
            this.get(API.GET_LAST_CONVERSATION, hashMap, new ReqCallback<String>(){

                @Override
                public void onReqSuccess(String result) {
                    if (!TextUtils.isEmpty((CharSequence)result)) {
                        try {
                            List<ConversationMsg> list = ConversationHelper.getRetrievedMsgList(new JSONObject(result));
                            ((ConversationFragment)ConversationPresenter.this.mView).onLastConversationRetrieved(list);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void onFailure(String url, int errorCode, String errorMsg) {
                    ((ConversationFragment)ConversationPresenter.this.mView).onLastConversationRetrieved(null);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goFetchUnreadMessageCount() {
        try {
            JSONObject params = new JSONObject();
            params.put("appid", (Object)Const.APP_ID);
            params.put("uid", (Object)UserProfile.USER_ID);
            this.get(API.FETCH_NEW_MSG, params, new ReqCallback<String>(){

                @Override
                public void onReqSuccess(String result) {
                    try {
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            JSONObject jsonObject = new JSONObject(result);
                            Const.TOGGLE_FETCH_MESSAGE = jsonObject.optBoolean("isHaveChat");
                            int newCount = jsonObject.optInt("cs_message_count");
                            ConversationPresenter.this.mSp.put(UserProfile.USER_ID, newCount);
                            if (Const.TOGGLE_OPEN_UNREAD_MSG && Const.sMessageListener != null) {
                                Const.sMessageListener.onMessageCountArrived(0);
                            }
                        }
                    }
                    catch (Exception e) {
                        TLog.e("Conversation fetch new msg failed, because " + e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCachedUnreadMessageCount(boolean withdrawMessage) {
        int cacheCount = this.mSp.getInt(UserProfile.USER_ID, 0);
        this.mSp.put(UserProfile.USER_ID, withdrawMessage ? --cacheCount : ++cacheCount);
    }

    public String getInputDraft() {
        return this.mSp.getString("sp_input_draft", "");
    }

    public void clearInputDraft() {
        this.mSp.put("sp_input_draft", "");
    }
}

