/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.config.ConversationConfig;
import net.aihelp.config.UserConfig;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IView;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.data.local.InitRepository;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.model.init.InitEntity;
import net.aihelp.ui.helper.MessageSyncHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.listener.OnAIHelpInitializedCallback;
import net.aihelp.ui.listener.OnAIHelpSessionCloseCallback;
import net.aihelp.ui.listener.OnAIHelpSessionOpenCallback;
import net.aihelp.ui.listener.OnMessageCountArrivedCallback;
import net.aihelp.ui.listener.OnNetworkCheckResultCallback;
import net.aihelp.ui.listener.OnOperationUnreadChangedCallback;
import net.aihelp.ui.listener.OnSpecificFormSubmittedCallback;
import net.aihelp.ui.listener.OnSpecificUrlClickedCallback;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.LocaleUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.TLog;
import org.json.JSONException;
import org.json.JSONObject;

public class InitPresenter
extends AbsPresenter<IView, InitRepository> {
    private OnAIHelpInitializedCallback mInitListener;
    private final RetryInitHandler mRetryInitHandler = new RetryInitHandler(this);
    private ScheduledFuture<?> unreadMsgFuture;

    public InitPresenter(Context context, String appKey, String domain, String appId, String language) {
        super(context);
        ((InitRepository)this.mRepo).saveInitConfig(appKey, domain, appId, language);
    }

    public void updateUserProfile(final UserConfig config) {
        String cachedCrmInfo;
        String latelyCrmInfo;
        if (config == null) {
            return;
        }
        ((InitRepository)this.mRepo).saveUserProfileConfig(config);
        Const.TOGGLE_FETCH_MESSAGE = true;
        ResponseMqttHelper.resetTicketStatusFlags();
        if (config.isSyncCrmInfo() && !(latelyCrmInfo = String.format("%s|%s", config.getUserId(), config.getUserTags())).equals(cachedCrmInfo = this.mSp.getString("crmInfo_" + config.getUserId()))) {
            try {
                JSONObject json = new JSONObject();
                json.put("userName", (Object)config.getUserName());
                json.put("uId", (Object)config.getUserId());
                json.put("tags", (Object)config.getUserTags());
                this.post(API.SYNC_VIP_INFO, json, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        ((InitRepository)InitPresenter.this.mRepo).saveCrmInfo(config.getUserId(), config.getUserTags());
                    }
                });
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (config.getPushToken() != null) {
            this.postCrmPushTokenInfo(config.getPushToken(), config.getPushPlatform().getValue());
        }
    }

    public void updateConversationFields(ConversationConfig config) {
        ((InitRepository)this.mRepo).updateConversationFields(config.getWelcomeMessage(), config.getStoryNode());
    }

    public void doInitForAIHelp() {
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable(){

            @Override
            public void run() {
                InitPresenter.this.goLogDauStatus();
                InitPresenter.this.requestInit(true);
                MessageSyncHelper.syncLogMessage();
            }
        });
    }

    private void goLogDauStatus() {
        long initTime = this.mSp.getLong("sp_log_dau_time");
        if (!DateFormatUtil.isToday(initTime)) {
            try {
                JSONObject dauParams = new JSONObject();
                dauParams.put("deviceid", (Object)DeviceUuidFactory.id(this.mContext));
                this.post(API.LOG_DAU_URL, dauParams, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        ((InitRepository)InitPresenter.this.mRepo).saveDAULogTime(System.currentTimeMillis());
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void requestInit(final boolean requireCallback) {
        String spPrefix = String.format("%s_%s_", Const.APP_ID, Const.ORIGINAL_LANGUAGE);
        final long lastInitTime = this.mSp.getLong(spPrefix + "init_timestamp", System.currentTimeMillis());
        int requestLimit = this.mSp.getInt(spPrefix + "init_limit");
        final String cachedInitData = this.mSp.getString(spPrefix + "init_response");
        LocalizeHelper.resetLocalizeData();
        if (TextUtils.isEmpty((CharSequence)cachedInitData) || requestLimit < 0 || System.currentTimeMillis() - lastInitTime > (long)requestLimit) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("domain", (Object)API.HOST_URL);
                AIHelpRequest.getInstance().requestGetByAsync(API.INIT_URL, jsonObject, new ReqCallback<String>(){

                    @Override
                    public void onAsyncReqSuccess(String result) {
                        InitPresenter.this.mRetryInitHandler.removeCallbacksAndMessages(null);
                        InitPresenter.this.cacheInitResponse(requireCallback, result, System.currentTimeMillis());
                    }

                    @Override
                    public void onAsyncFailure(String url, int errorCode, String errorMsg) {
                        if (TextUtils.isEmpty((CharSequence)cachedInitData)) {
                            InitPresenter.this.mRetryInitHandler.retryInitRequest(errorCode);
                        } else {
                            InitPresenter.this.cacheInitResponse(requireCallback, cachedInitData, lastInitTime);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.cacheInitResponse(requireCallback, cachedInitData, lastInitTime);
        }
    }

    private void cacheInitResponse(final boolean requireCallback, String initResponse, long lastInitTime) {
        try {
            InitEntity initEntity = JsonHelper.toJavaObject(initResponse, InitEntity.class);
            if (initEntity != null) {
                ((InitRepository)this.mRepo).prepareInitData(initEntity, initResponse, lastInitTime);
                ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AIHelpContext.successfullyInit.set(true);
                        if (requireCallback && InitPresenter.this.mInitListener != null) {
                            InitPresenter.this.mInitListener.onAIHelpInitialized();
                            InitPresenter.this.mInitListener = null;
                        }
                    }
                });
            } else {
                AIHelpLogger.error("init error", new UnknownError(initResponse));
                Log.e((String)"AIHelp", (String)String.format("AIHelp SDK init failed, %s", initResponse));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void postCrmPushTokenInfo(String pushToken, int pushPlatform) {
        if (!TextUtils.isEmpty((CharSequence)pushToken) && pushPlatform > 0) {
            String cachedCrmPushInfo;
            String latelyCrmPushInfo;
            ((InitRepository)this.mRepo).saveMqttPushInfo(pushToken, pushPlatform);
            if (Const.TOGGLE_CRM_TOKEN && !(latelyCrmPushInfo = String.format("%s|%s|%s", UserProfile.USER_ID, pushToken, pushPlatform)).equals(cachedCrmPushInfo = this.mSp.getString("sp_crm_push_info"))) {
                try {
                    JSONObject params = new JSONObject();
                    params.put("token", (Object)pushToken);
                    params.put("pushTypeId", pushPlatform);
                    params.put("playerId", (Object)UserProfile.USER_ID);
                    params.put("playerName", (Object)UserProfile.USER_NAME);
                    params.put("language", (Object)Const.CORRECT_LANGUAGE);
                    params.put("deviceId", (Object)DeviceUuidFactory.id(this.mContext));
                    this.post(API.CRM_TOKEN_URL, params, new ReqCallback<String>(){

                        @Override
                        public void onReqSuccess(String result) {
                            InitPresenter.this.mSp.put("sp_crm_push_info", latelyCrmPushInfo);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void updateSDKLanguage(String sdkLanguage) {
        String formatLanguage = LocaleUtil.getFormatLanguage(sdkLanguage);
        if (!Const.ORIGINAL_LANGUAGE.equals(formatLanguage)) {
            AIHelpContext.successfullyInit.set(false);
            Const.CORRECT_LANGUAGE = Const.ORIGINAL_LANGUAGE = formatLanguage;
            this.requestInit(false);
        } else {
            Log.e((String)"TAG", (String)("AIHelp is using " + formatLanguage + " as global language already!"));
        }
    }

    public void setUploadLogPath(String logPath) {
        if (TextUtils.isEmpty((CharSequence)logPath)) {
            return;
        }
        if (logPath.endsWith(".txt") || logPath.endsWith(".log") || logPath.endsWith(".bytes")) {
            ((InitRepository)this.mRepo).setUploadLogPath(logPath);
        } else {
            TLog.e("Unsupported type, expected .txt, .log or .bytes file");
        }
    }

    public void setNetworkCheckHostAddress(String hostAddress, OnNetworkCheckResultCallback listener) {
        hostAddress = TextUtils.isEmpty((CharSequence)hostAddress) ? "aihelp.net" : hostAddress.replace("http://", "").replace("https://", "");
        ((InitRepository)this.mRepo).setNetworkCheckHostAddress(hostAddress);
        Const.sCheckResultListener = listener;
    }

    private void fetchUnreadMessageCount() {
        try {
            if (Const.IS_SDK_SHOWING) {
                TLog.e("AIHelp", "AIHelp session is visible to user, do not need fetch for unread messages.");
                return;
            }
            if (!Const.TOGGLE_FETCH_MESSAGE) {
                TLog.e("AIHelp", String.format("Current user(%s) does not have any active tickets at present.", UserProfile.USER_ID));
                return;
            }
            JSONObject params = new JSONObject();
            params.put("appid", (Object)Const.APP_ID);
            params.put("uid", (Object)UserProfile.USER_ID);
            if (UserProfile.USER_ID.equals(DeviceUuidFactory.id(this.mContext))) {
                TLog.e("AIHelp", "The userId you're using for unread message polling is AIHelp's generated deviceId, please verify if this is what you want.");
            }
            this.get(API.FETCH_NEW_MSG, params, new ReqCallback<String>(){

                @Override
                public void onReqSuccess(String result) {
                    try {
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            JSONObject jsonObject = new JSONObject(result);
                            Const.TOGGLE_FETCH_MESSAGE = jsonObject.optBoolean("isHaveChat");
                            int newCount = jsonObject.optInt("cs_message_count");
                            int cachedCount = Math.max(0, InitPresenter.this.mSp.getInt(UserProfile.USER_ID));
                            if (Const.sMessageListener != null) {
                                Const.sMessageListener.onMessageCountArrived(Math.max(0, newCount - cachedCount));
                            }
                        }
                    }
                    catch (Exception e) {
                        TLog.e("Unread msg count polling failed, because " + e.toString());
                    }
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void startUnreadMessagePolling(OnMessageCountArrivedCallback listener) {
        if (SpUtil.getInstance().getBoolean("sp_log_toggle")) {
            Const.LIMIT_CHECKING_UNREAD = 10;
        }
        if (listener != null && this.unreadMsgFuture == null && Const.TOGGLE_OPEN_UNREAD_MSG && Const.LIMIT_CHECKING_UNREAD > 0 && !TextUtils.isEmpty((CharSequence)UserProfile.USER_ID)) {
            Const.sMessageListener = listener;
            this.unreadMsgFuture = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    InitPresenter.this.fetchUnreadMessageCount();
                }
            }, 0L, Const.LIMIT_CHECKING_UNREAD, TimeUnit.SECONDS);
        }
    }

    public void loadUpListeners(OnAIHelpInitializedCallback listener) {
        if (listener != null && this.mInitListener == null) {
            this.mInitListener = listener;
        }
    }

    public void setOnSpecificFormSubmittedCallback(OnSpecificFormSubmittedCallback callback) {
        Const.sSpecificFormSubmittedListener = callback;
    }

    public void setOnAIHelpSessionOpenCallback(OnAIHelpSessionOpenCallback callback) {
        Const.sSessionOpenListener = callback;
    }

    public void setOnAIHelpSessionCloseCallback(OnAIHelpSessionCloseCallback callback) {
        Const.sSessionCloseListener = callback;
    }

    public void setOnSpecificUrlClickedCallback(OnSpecificUrlClickedCallback callback) {
        Const.sOnSpecificUrlClickedListener = callback;
    }

    public void setOnOperationUnreadChangedCallback(OnOperationUnreadChangedCallback callback) {
        Const.sOperationUnreadListener = callback;
        ApiExecutorFactory.getHandlerExecutor().runAsyncDelayed(new Runnable(){

            @Override
            public void run() {
                if (Const.sOperationUnreadListener != null) {
                    Const.sOperationUnreadListener.onOperationUnreadChanged(OperateHelper.INSTANCE.haveUnreadArticles());
                }
            }
        }, 1000L);
    }

    public static class RetryInitHandler
    extends Handler {
        private int retryCount;
        private final InitPresenter initPresenter;

        public RetryInitHandler(InitPresenter initPresenter) {
            this.initPresenter = initPresenter;
        }

        public void retryInitRequest(int code) {
            if (code >= 200 && code < 300 || code >= 400 && code < 600) {
                return;
            }
            if (this.retryCount++ < 3) {
                this.sendEmptyMessageDelayed(0, 20000L);
            } else {
                this.removeCallbacksAndMessages(null);
            }
        }

        public void handleMessage(@NonNull Message msg) {
            this.initPresenter.requestInit(true);
        }
    }
}

