/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.db.bot.controller;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.db.bot.ConversationSQLiteHelper;
import net.aihelp.db.util.ContentValuesUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ElvaDBController {
    private final ConversationSQLiteHelper dbHelper = ConversationSQLiteHelper.getInstance();

    private ElvaDBController() {
    }

    public void storeElvaBotMsg(long timeStamp, String rawResponse) {
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            database.insert("elva_bot", null, ContentValuesUtil.getElvaBotContentValues(timeStamp, rawResponse));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void clearElvaMsg() {
        if (!TextUtils.isEmpty((CharSequence)UserProfile.USER_ID)) {
            try {
                String whereClause = "uid=?";
                String[] whereArgs = new String[]{UserProfile.USER_ID};
                SQLiteDatabase database = this.dbHelper.getWritableDatabase();
                database.delete("elva_bot", whereClause, whereArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getElvaMsgArray() {
        JSONArray msgArray = new JSONArray();
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            String whereClause = "uid = ? AND app_id = ? AND app_server = ?";
            String[] whereArgs = new String[]{UserProfile.USER_ID, Const.APP_ID, API.HOST_URL};
            cursor = database.query("elva_bot", null, whereClause, whereArgs, null, null, null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    String rawResponse = cursor.getString(cursor.getColumnIndex("raw_response"));
                    msgArray.put((Object)new JSONObject(rawResponse));
                    cursor.moveToNext();
                }
            }
        }
        return msgArray;
    }

    public static ElvaDBController getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static final class LazyHolder {
        static final ElvaDBController INSTANCE = new ElvaDBController();

        private LazyHolder() {
        }
    }
}

