/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.ui.adapter.ItemViewDelegate;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.cs.storyline.BotTag;
import net.aihelp.data.model.cs.storyline.BotUrl;
import net.aihelp.ui.adapter.MessageListAdapter;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.URLEncodeUtil;

public abstract class BaseMsgAdapter
implements ItemViewDelegate<ConversationMsg> {
    private static final String REGEX_IMAGE = "(http:|https:)(//)((?!\").)*?.(PNG|png|JPG|jpg|JPEG|jpeg)";
    private static final String REGEX_RICH_TEXT = "(http:|https:)(//)\\S*?((?=\\s+http)|\\.(PNG|png|JPG|jpg|JPEG|jpeg))|(http:|https:)(//)((?!\").)*";
    protected final Context mContext;
    protected MessageListAdapter.OnClickedListenerWrapper mWrapper;
    protected List<ConversationMsg> dataList = new ArrayList<ConversationMsg>();
    protected boolean isCurrentRtl;

    public BaseMsgAdapter(Context context) {
        this.mContext = context;
        if (Build.VERSION.SDK_INT >= 17) {
            this.isCurrentRtl = context.getResources().getConfiguration().getLayoutDirection() == 1;
        }
    }

    protected Drawable getAdminBackgroundDrawable(boolean isRtl) {
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        return isRtl ? Styles.getDrawableWithCorner(colorFromHex, 15, 0, 15, 15) : Styles.getDrawableWithCorner(colorFromHex, 0, 15, 15, 15);
    }

    public void setOnClickedListenerWrapper(MessageListAdapter.OnClickedListenerWrapper mWrapper) {
        this.mWrapper = mWrapper;
    }

    protected TextView getMsg(String botMsg) {
        boolean isSamsungOreo;
        Matcher matcher;
        if (!TextUtils.isEmpty((CharSequence)botMsg) && botMsg.contains("&formUrlTitle=") && (matcher = Pattern.compile("(http:|https:)(//)((?!\").)*?(&formUrlTitle=)*?").matcher(botMsg)).matches()) {
            botMsg = botMsg + "&fromSdk=1&isCustom=1";
            Matcher subMatcher = Pattern.compile("(?<=(formUrlTitle=)).*(?=(&fromSdk=1&isCustom=1))").matcher(botMsg);
            String formTitle = botMsg;
            if (subMatcher.find()) {
                formTitle = URLEncodeUtil.decode(subMatcher.group());
            }
            return this.getUrl(new BotUrl(formTitle, botMsg), this.mWrapper);
        }
        TextView textView = new TextView(this.mContext);
        textView.setTextSize(14.0f);
        textView.setLineSpacing((float)this.dip2px(this.mContext, 3.0), 1.0f);
        textView.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
        textView.setTextIsSelectable(true);
        boolean isMIUI12 = ("XiaoMi".equalsIgnoreCase(Build.MANUFACTURER) || "RedMi".equalsIgnoreCase(Build.MANUFACTURER)) && Build.VERSION.SDK_INT <= 30;
        boolean bl = isSamsungOreo = "samsung".equalsIgnoreCase(Build.MANUFACTURER) && Build.VERSION.SDK_INT <= 26;
        if (isMIUI12 || isSamsungOreo) {
            textView.setText((CharSequence)botMsg);
        } else {
            textView.setText((CharSequence)this.getUrlSupportedText(botMsg));
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }
        return textView;
    }

    protected View getRichTextMsg(String msg) {
        LinearLayout layout = new LinearLayout(this.mContext);
        layout.setOrientation(1);
        layout.setGravity(0x800003);
        try {
            LinkedList<Integer> urlIndexList = new LinkedList<Integer>();
            urlIndexList.add(0);
            Matcher formMatcher = Pattern.compile(REGEX_RICH_TEXT).matcher(msg);
            while (formMatcher.find()) {
                urlIndexList.add(formMatcher.start());
                urlIndexList.add(formMatcher.end());
            }
            if (((Integer)urlIndexList.getLast()).intValue() != msg.length()) {
                urlIndexList.add(msg.length());
            }
            for (int i = 0; i < urlIndexList.size() - 1; ++i) {
                String urlOrRawText = msg.substring((Integer)urlIndexList.get(i), (Integer)urlIndexList.get(i + 1)).trim();
                if (Pattern.compile("\\s*?").matcher(urlOrRawText).matches()) continue;
                if (Pattern.compile(REGEX_IMAGE).matcher(urlOrRawText).matches()) {
                    ImageView imageView = new ImageView(this.mContext);
                    imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                    imageView.setAdjustViewBounds(true);
                    final String adjustedUrl = DomainSupportHelper.getAdjustedUrl(urlOrRawText);
                    Picasso.get().load(adjustedUrl).into(imageView);
                    imageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            ImageViewer imageViewer = ImageViewer.getDefault(BaseMsgAdapter.this.mContext);
                            imageViewer.updateImageResource(adjustedUrl);
                            imageViewer.show();
                        }
                    });
                    layout.addView((View)imageView);
                    continue;
                }
                TextView textView = this.getMsg(urlOrRawText);
                textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                layout.addView((View)textView);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layout;
    }

    protected TextView getUrl(final BotUrl botUrl, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)String.format("%s", botUrl.getUrlTitle()));
        textView.setTextSize(14.0f);
        textView.setClickable(true);
        textView.setTextColor(Styles.getClickableTextColor(CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String url = botUrl.getUrlAddress();
                if (AppInfoUtil.isUrlStillNeedResponding(BaseMsgAdapter.this.mContext, url) && wrapper != null) {
                    wrapper.onUrlClicked(url);
                }
            }
        });
        textView.setPadding(0, this.dip2px(this.mContext, 5.0), 0, this.dip2px(this.mContext, 5.0));
        return textView;
    }

    protected TextView getFormUrl(final ElvaBotMsg botMsg, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)String.format("%s", botMsg.getBotFormUrl().getFormTitle()));
        textView.setTextSize(14.0f);
        textView.setClickable(true);
        textView.setTextColor(Styles.getClickableTextColor(CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String formUrl = BaseMsgAdapter.this.getFormattedFormUrl(botMsg);
                if (AppInfoUtil.isUrlStillNeedResponding(BaseMsgAdapter.this.mContext, formUrl) && wrapper != null) {
                    wrapper.onFormUrlClicked(botMsg.getTimeStamp(), formUrl);
                }
            }
        });
        textView.setPadding(0, this.dip2px(this.mContext, 5.0), 0, this.dip2px(this.mContext, 5.0));
        return textView;
    }

    protected TextView getBotOrderInfo(final ElvaBotMsg botMsg, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)String.format("%s", botMsg.getBotOrderInfo().getName()));
        textView.setTextSize(14.0f);
        textView.setClickable(true);
        textView.setTextColor(Styles.getClickableTextColor(CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (wrapper != null && FastClickValidator.validate()) {
                    wrapper.onOrderInfoClicked(botMsg.getBotOrderInfo());
                }
            }
        });
        textView.setPadding(0, this.dip2px(this.mContext, 5.0), 0, this.dip2px(this.mContext, 5.0));
        return textView;
    }

    protected TextView getAction(int index, final String actionName, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)String.format("%s %s", "\u00b7", actionName));
        textView.setTextSize(14.0f);
        textView.setClickable(true);
        textView.setTextColor(Styles.getClickableTextColor(CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (wrapper != null && FastClickValidator.validate() && !TextUtils.isEmpty((CharSequence)actionName) && !TextUtils.isEmpty((CharSequence)actionName.trim())) {
                    wrapper.onActionClicked(actionName);
                }
            }
        });
        textView.setPadding(0, this.dip2px(this.mContext, 5.0), 0, this.dip2px(this.mContext, 5.0));
        return textView;
    }

    protected View getFAQLayout(final ElvaBotMsg botMsg, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        LinearLayout layout = new LinearLayout(this.mContext);
        layout.setOrientation(1);
        if (botMsg.isHasUrl()) {
            View.OnClickListener onClickListener = new View.OnClickListener(){

                public void onClick(View v) {
                    if (wrapper != null && FastClickValidator.validate()) {
                        BotUrl botUrl = botMsg.getBotUrl();
                        if (botUrl != null) {
                            String url = botUrl.getUrlAddress();
                            if (!url.contains("isCustom=1")) {
                                url = url + "&isCustom=1";
                            }
                            botUrl.setUrlAddress(url);
                        }
                        wrapper.onFaqClicked(botMsg);
                        StatisticHelper.whenBotFAQClicked(botMsg);
                        botMsg.setFaqViewed(true);
                    }
                }
            };
            TextView faqContent = new TextView(this.mContext);
            faqContent.setTextSize(15.0f);
            faqContent.setLineSpacing((float)this.dip2px(this.mContext, 3.0), 1.0f);
            faqContent.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
            faqContent.setPadding(0, this.dip2px(this.mContext, 5.0), 0, this.dip2px(this.mContext, 12.0));
            faqContent.setText((CharSequence)botMsg.getTemplate());
            layout.addView((View)faqContent);
            TextView tvShowMore = new TextView(this.mContext);
            tvShowMore.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            tvShowMore.setTextSize(15.0f);
            tvShowMore.setGravity(17);
            tvShowMore.setLineSpacing((float)this.dip2px(this.mContext, 3.0), 1.0f);
            tvShowMore.setTextColor(Styles.getClickableTextColor(CustomConfig.CommonSetting.interactElementTextColor));
            tvShowMore.setPadding(0, this.dip2px(this.mContext, 7.0), 0, this.dip2px(this.mContext, 7.0));
            tvShowMore.setText((CharSequence)ResResolver.getString("aihelp_view_details"));
            tvShowMore.setOnClickListener(onClickListener);
            layout.addView((View)tvShowMore);
        }
        if (botMsg.isHasFormUrl()) {
            View divider = new View(this.mContext);
            divider.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, (double)0.1f));
            divider.setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-1, this.dip2px(this.mContext, 1.0)));
            divider.setPadding(0, this.dip2px(this.mContext, 5.0), 0, this.dip2px(this.mContext, 5.0));
            layout.addView(divider);
            TextView formUrl = this.getFormUrl(botMsg, this.mWrapper);
            formUrl.setTypeface(Typeface.defaultFromStyle((int)1));
            formUrl.setPadding(0, this.dip2px(this.mContext, 12.0), 0, this.dip2px(this.mContext, 5.0));
            layout.addView((View)formUrl);
        }
        return layout;
    }

    private String getFormattedFormUrl(ElvaBotMsg botMsg) {
        return String.format("%s&appId=%s&userId=%s&serverId=%s&platform=%s&sdkVersion=%s&isTicket=1&%s&hasPermission=%s&fromSdk=1&isCustom=1", botMsg.getBotFormUrl().getFormAddress(), Const.APP_ID, UserProfile.USER_ID, UserProfile.SERVER_ID, 2, "3.3.12", this.getTagParams(botMsg), 0);
    }

    private String getTagParams(ElvaBotMsg botMsg) {
        StringBuilder tagId = new StringBuilder();
        StringBuilder tagName = new StringBuilder();
        if (botMsg.isHasTag()) {
            List<BotTag> tagList = botMsg.getBotTagList();
            for (int i = 0; i < tagList.size(); ++i) {
                tagId.append(tagList.get(i).getTagId());
                if (i != tagList.size() - 1) {
                    tagId.append(",");
                }
                tagName.append(tagList.get(i).getTagName());
                if (i == tagList.size() - 1) continue;
                tagName.append(",");
            }
        }
        return String.format("tagId=%s&tagName=%s", tagId.toString(), tagName.toString());
    }

    @Override
    public void onDataSourceUpdated(List<ConversationMsg> data) {
        this.dataList.clear();
        this.dataList.addAll(data);
    }

    protected SpannableStringBuilder getUrlSupportedText(String msg, final String urlTextColor) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return new SpannableStringBuilder((CharSequence)"");
        }
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)msg);
        Matcher matcher = Pattern.compile("\\S+(://)\\S+").matcher((CharSequence)ssb);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            final String url = matcher.group();
            ClickableSpan clickableSpan = new ClickableSpan(){

                public void onClick(View view) {
                    if (AppInfoUtil.isUrlStillNeedResponding(BaseMsgAdapter.this.mContext, url) && BaseMsgAdapter.this.mWrapper != null) {
                        BaseMsgAdapter.this.mWrapper.onUrlClicked(url);
                    }
                }

                public void updateDrawState(TextPaint dp) {
                    dp.setColor(Color.parseColor((String)urlTextColor));
                }
            };
            ssb.setSpan((Object)clickableSpan, start, end, 34);
            ssb.setSpan((Object)new UnderlineSpan(), start, end, 34);
        }
        return ssb;
    }

    protected SpannableStringBuilder getUrlSupportedText(String msg) {
        return this.getUrlSupportedText(msg, CustomConfig.CommonSetting.interactElementTextColor);
    }

    protected int getViewId(String name) {
        return ResResolver.getViewId(name);
    }

    protected int dip2px(Context context, double dpValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * (double)density + 0.5);
    }
}

