/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AdminImageAdapter
extends BaseMsgAdapter {
    public AdminImageAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_admin_image");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == 8;
    }

    @Override
    public void convert(ViewHolder holder, final ConversationMsg conversationMsg, int position) {
        Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_admin");
        TextView tvNickname = (TextView)holder.getView(this.getViewId("aihelp_tv_nickname"));
        if (CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)conversationMsg.getNickname())) {
            tvNickname.setVisibility(0);
            tvNickname.setText((CharSequence)conversationMsg.getNickname());
            tvNickname.setTextSize(13.0f);
            tvNickname.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8));
        } else {
            tvNickname.setVisibility(8);
        }
        final AIHelpLoadingImageView imageView = (AIHelpLoadingImageView)((Object)holder.getView(this.getViewId("aihelp_iv_holder")));
        imageView.loadIntoImageView(this.mContext, conversationMsg);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (imageView.isLoading()) {
                    return;
                }
                ImageViewer imageViewer = ImageViewer.getDefault(AdminImageAdapter.this.mContext);
                imageViewer.updateImageResource(conversationMsg.getMsgContent());
                imageViewer.show();
            }
        });
    }
}

