/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import org.json.JSONObject;

public class AdminTextAdapter
extends BaseMsgAdapter {
    public AdminTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_admin");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == 1;
    }

    @Override
    public void convert(ViewHolder holder, ConversationMsg s, int position) {
        LinearLayout llContainer = (LinearLayout)holder.getView(this.getViewId("aihelp_admin_message_container"));
        llContainer.setBackground(this.getAdminBackgroundDrawable(this.isCurrentRtl));
        llContainer.removeAllViews();
        boolean isElvaBot = s instanceof ElvaBotMsg;
        ImageView ivPortrait = (ImageView)holder.getView(this.getViewId("aihelp_iv_portrait"));
        Styles.loadIcon(ivPortrait, isElvaBot ? CustomConfig.CustomerService.csBotSupportPortrait : CustomConfig.CustomerService.csManualSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, isElvaBot ? "aihelp_svg_portrait_robot" : "aihelp_svg_portrait_admin");
        if (isElvaBot) {
            this.convertElvaBotTextMsg((ViewGroup)llContainer, (ElvaBotMsg)s);
            holder.setVisible(this.getViewId("aihelp_iv_translate"), false);
        } else {
            holder.setVisible(this.getViewId("aihelp_iv_translate"), Const.TOGGLE_TRANSLATE_CS_MESSAGE);
            this.convertSupportTextMsg(holder, (ViewGroup)llContainer, s, position);
        }
    }

    private void convertSupportTextMsg(ViewHolder holder, ViewGroup container, ConversationMsg msg, int position) {
        TextView tvNickname = (TextView)holder.getView(this.getViewId("aihelp_tv_nickname"));
        if (CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)msg.getNickname())) {
            tvNickname.setVisibility(0);
            tvNickname.setText((CharSequence)msg.getNickname());
            tvNickname.setTextSize(13.0f);
            tvNickname.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8));
        } else {
            tvNickname.setVisibility(8);
        }
        TextView textView = this.getMsg(msg.getMsgContent());
        textView.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
        this.prepareTranslate(holder, textView, position);
        container.addView((View)textView);
    }

    private void convertElvaBotTextMsg(ViewGroup container, ElvaBotMsg botMsg) {
        container.addView((View)this.getMsg(botMsg.getBotMsg()));
        if (botMsg.isHasUrl()) {
            container.addView((View)this.getUrl(botMsg.getBotUrl(), this.mWrapper));
        }
        if (botMsg.isHasFormUrl()) {
            container.addView((View)this.getFormUrl(botMsg, this.mWrapper));
        }
        if (botMsg.isHasOrderInfo()) {
            container.addView((View)this.getBotOrderInfo(botMsg, this.mWrapper));
        }
        if (botMsg.isHasAction()) {
            for (int i = 0; i < botMsg.getActions().size(); ++i) {
                container.addView((View)this.getAction(i + 1, botMsg.getActions().get(i), this.mWrapper));
            }
        }
    }

    private void prepareTranslate(final ViewHolder holder, final TextView textView, int position) {
        if (Const.TOGGLE_TRANSLATE_CS_MESSAGE) {
            int maxTextWidth = Styles.getScreenWidth(this.mContext) - this.dip2px(this.mContext, 165.0);
            textView.setMaxWidth(maxTextWidth);
            final String originContent = textView.getText().toString();
            final StringBuilder translatedContent = new StringBuilder(originContent);
            holder.setOnClickListener(this.getViewId("aihelp_iv_translate"), new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        JSONObject params = new JSONObject();
                        params.put("deviceId", (Object)DeviceUuidFactory.id(AdminTextAdapter.this.mContext));
                        params.put("playerId", (Object)UserProfile.USER_ID);
                        params.put("content", (Object)originContent);
                        AIHelpRequest.getInstance().requestPostByJson(API.TRANSLATE_MESSAGE, params, new ReqCallback<String>(){

                            @Override
                            public void onReqSuccess(String result) {
                                translatedContent.append("\n---------\n").append(result);
                                textView.setText((CharSequence)translatedContent.toString());
                                textView.setMaxWidth(Integer.MAX_VALUE);
                            }
                        });
                        holder.setVisible(AdminTextAdapter.this.getViewId("aihelp_iv_translate"), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

