/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class UserImageAdapter
extends BaseMsgAdapter {
    public UserImageAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_image");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == 6;
    }

    @Override
    public void convert(ViewHolder holder, final ConversationMsg conversationMsg, final int position) {
        Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");
        holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), false);
        final AIHelpLoadingImageView imageView = (AIHelpLoadingImageView)((Object)holder.getView(this.getViewId("aihelp_iv_holder")));
        imageView.loadIntoImageView(this.mContext, conversationMsg);
        if (conversationMsg.getMsgStatus() == 1002) {
            holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), true);
            holder.setOnClickListener(this.getViewId("aihelp_iv_msg_retry"), new View.OnClickListener(){

                public void onClick(View v) {
                    if (UserImageAdapter.this.mWrapper != null) {
                        UserImageAdapter.this.mWrapper.onRetrySendingMessage(position, conversationMsg);
                    }
                }
            });
            return;
        }
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (imageView.isLoading()) {
                    return;
                }
                ImageViewer imageViewer = ImageViewer.getDefault(UserImageAdapter.this.mContext);
                imageViewer.updateImageResource(conversationMsg.getMsgContent());
                imageViewer.show();
            }
        });
    }
}

