/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageButton;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class UserTextAdapter
extends BaseMsgAdapter {
    public UserTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == 2 || item.getMsgType() == 3;
    }

    @Override
    public void convert(ViewHolder holder, final ConversationMsg s, final int position) {
        this.updateMsgSendingStatus(holder, s.getMsgContent(), s.getMsgStatus());
        holder.setOnClickListener(this.getViewId("aihelp_iv_msg_retry"), new View.OnClickListener(){

            public void onClick(View v) {
                if (UserTextAdapter.this.mWrapper != null) {
                    UserTextAdapter.this.mWrapper.onRetrySendingMessage(position, s);
                }
            }
        });
    }

    private void updateMsgSendingStatus(ViewHolder holder, String msgContent, int status) {
        Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");
        TextView msgView = (TextView)holder.getView(this.getViewId("aihelp_admin_message_text"));
        msgView.setText((CharSequence)this.getUrlSupportedText(msgContent, CustomConfig.CommonSetting.highlightedColor));
        msgView.setTextColor(-1);
        msgView.setMovementMethod(LinkMovementMethod.getInstance());
        msgView.setMaxWidth(Math.max(this.getRightfulMaxWidth(holder), this.dip2px(this.mContext, 200.0)));
        msgView.setBackground(this.getUserBackgroundDrawable(this.isCurrentRtl));
        AppCompatImageButton retryButton = (AppCompatImageButton)holder.getView(this.getViewId("aihelp_iv_msg_retry"));
        switch (status) {
            case 1003: {
                holder.setVisible(this.getViewId("aihelp_iv_msg_sending"), false);
                holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), false);
                break;
            }
            case 1001: {
                holder.setVisible(this.getViewId("aihelp_iv_msg_sending"), true);
                holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), false);
                break;
            }
            case 1002: {
                holder.setVisible(this.getViewId("aihelp_iv_msg_sending"), false);
                holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), true);
                retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_retry"));
                break;
            }
            case 1004: {
                holder.setVisible(this.getViewId("aihelp_iv_msg_sending"), false);
                holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), true);
                retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_failed"));
            }
        }
    }

    private int getRightfulMaxWidth(ViewHolder holder) {
        ImageView ivPortrait = (ImageView)holder.getView(this.getViewId("aihelp_iv_portrait"));
        TextView tvMsg = (TextView)holder.getView(this.getViewId("aihelp_admin_message_text"));
        return Styles.getScreenWidth(this.mContext) - (this.dip2px(this.mContext, 39.0) + ((ViewGroup.MarginLayoutParams)ivPortrait.getLayoutParams()).rightMargin + ((ViewGroup.MarginLayoutParams)tvMsg.getLayoutParams()).rightMargin) * 2;
    }

    private Drawable getUserBackgroundDrawable(boolean isRtl) {
        int colorFromHex = Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor);
        return isRtl ? Styles.getDrawableWithCorner(colorFromHex, 0, 15, 15, 15) : Styles.getDrawableWithCorner(colorFromHex, 15, 0, 15, 15);
    }
}

