/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.user;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

public class UserVideoAdapter
extends BaseMsgAdapter {
    private final ExecutorService mExecutorService = Executors.newCachedThreadPool();

    public UserVideoAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_video");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == 7;
    }

    @Override
    public void convert(final ViewHolder holder, final ConversationMsg conversationMsg, final int position) {
        Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");
        holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), false);
        if (conversationMsg.getVideoThumbnail() != null) {
            this.loadUpImageView(holder, conversationMsg, position);
        } else if (this.mExecutorService != null) {
            this.mExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    conversationMsg.prepareVideoThumbnail();
                    if (UserVideoAdapter.this.mContext instanceof Activity && ((Activity)UserVideoAdapter.this.mContext).isFinishing()) {
                        TLog.e("You cannot start a load for a destroyed activity, interrupt current invoke.");
                        return;
                    }
                    ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            UserVideoAdapter.this.loadUpImageView(holder, conversationMsg, position);
                        }
                    });
                }
            });
        }
    }

    private void loadUpImageView(ViewHolder holder, final ConversationMsg conversationMsg, final int position) {
        final AIHelpLoadingImageView imageView = (AIHelpLoadingImageView)((Object)holder.getView(this.getViewId("aihelp_iv_holder")));
        imageView.loadIntoImageView(this.mContext, conversationMsg);
        if (conversationMsg.getMsgStatus() == 1002) {
            holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), true);
            holder.setOnClickListener(this.getViewId("aihelp_iv_msg_retry"), new View.OnClickListener(){

                public void onClick(View v) {
                    if (UserVideoAdapter.this.mWrapper != null) {
                        UserVideoAdapter.this.mWrapper.onRetrySendingMessage(position, conversationMsg);
                    }
                }
            });
            return;
        }
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (imageView.isLoading()) {
                    return;
                }
                ImageViewer.getDefault(UserVideoAdapter.this.mContext).updateVideoResource(conversationMsg.getVideoThumbnail(), conversationMsg.getMsgContent()).show();
            }
        });
    }
}

