/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.faq;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.widget.AIHelpServiceEntrance;
import net.aihelp.ui.wrapper.FaqSelectedListenerWrapper;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class FaqCardLayoutAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int VIEW_TYPE_CS_ENTRANCE = 1;
    private final Context context;
    private boolean isGridLayout;
    private final boolean isFooterVisible;
    private Bundle bundle;
    private IFaqEventListener faqEventListener;
    private final List<FaqListEntity> mDataSources = new ArrayList<FaqListEntity>();
    private FaqSelectedListenerWrapper mListener;

    public void setup(Bundle bundle, IFaqEventListener faqEventListener) {
        this.bundle = bundle;
        this.faqEventListener = faqEventListener;
    }

    public FaqCardLayoutAdapter(Context context) {
        this(context, false);
    }

    public FaqCardLayoutAdapter(Context context, boolean isFooterVisible) {
        this.context = context;
        this.isFooterVisible = isFooterVisible;
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void update(List<FaqListEntity> dataSources) {
        this.mDataSources.clear();
        if (!ListUtil.isListEmpty(dataSources)) {
            this.mDataSources.addAll(dataSources);
        }
        this.notifyDataSetChanged();
    }

    public void setOnFaqSelectedListener(FaqSelectedListenerWrapper mListener) {
        this.mListener = mListener;
    }

    public int getItemViewType(int position) {
        if (this.isFooterVisible && position == this.getItemCount() - 1) {
            return 1;
        }
        return super.getItemViewType(position);
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 1) {
            int layoutId = ResResolver.getLayoutId("aihelp_ada_faq_cs_entrance");
            View itemView = LayoutInflater.from((Context)this.context).inflate(layoutId, parent, false);
            return new CSEntranceViewHolder(itemView);
        }
        int layoutId = ResResolver.getLayoutId(this.isGridLayout ? "aihelp_ada_faq_grid_list" : "aihelp_ada_faq_linear_list");
        View itemView = LayoutInflater.from((Context)this.context).inflate(layoutId, parent, false);
        itemView.setBackground((Drawable)Styles.getClickableDrawableForList());
        return new ItemViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        if (viewHolder instanceof ItemViewHolder) {
            final FaqListEntity faq = this.mDataSources.get(position);
            switch (faq.getDisplayType()) {
                case 1: 
                case 6: {
                    this.convertFaqHomeList(viewHolder, faq);
                    break;
                }
                case 2: 
                case 3: {
                    this.convertFaqSectionOrQuestionList(viewHolder, faq);
                    break;
                }
                case 4: {
                    this.convertSearchMatchingList(viewHolder, faq);
                }
            }
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FaqCardLayoutAdapter.this.mListener != null) {
                        switch (faq.getDisplayType()) {
                            case 1: 
                            case 2: {
                                FaqCardLayoutAdapter.this.mListener.onIntentToSubSectionOrQuestionList(faq);
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                FaqCardLayoutAdapter.this.mListener.onIntentToQuestionContent(faq.getId(), faq.getQuery());
                            }
                        }
                    }
                }
            });
        }
        if (viewHolder instanceof CSEntranceViewHolder) {
            CSEntranceViewHolder holder = (CSEntranceViewHolder)viewHolder;
            holder.csService.setup(this.bundle, this.faqEventListener);
        }
    }

    private void convertFaqHomeList(RecyclerView.ViewHolder viewHolder, FaqListEntity faq) {
        boolean sectionIcon;
        ItemViewHolder holder = (ItemViewHolder)viewHolder;
        boolean hotTopicIcon = faq.getDisplayType() == 6 && CustomConfig.HelpCenter.isFaqHotTopicItemIconVisible;
        boolean bl = sectionIcon = faq.getDisplayType() == 1 && CustomConfig.HelpCenter.isFaqSectionItemIconVisible;
        if (hotTopicIcon || sectionIcon) {
            holder.ivTitle.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)faq.getIconUrl())) {
                Styles.loadIcon(holder.ivTitle, faq.getIconUrl());
            }
        }
        holder.tvTitle.setText((CharSequence)faq.getTitle());
        holder.tvTitle.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
        holder.tvTitle.setTextSize(15.0f);
    }

    private void convertFaqSectionOrQuestionList(RecyclerView.ViewHolder viewHolder, FaqListEntity faq) {
        ItemViewHolder holder = (ItemViewHolder)viewHolder;
        holder.ivTitle.setVisibility(8);
        holder.tvTitle.setText((CharSequence)faq.getTitle());
        holder.tvTitle.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
        holder.tvTitle.setTextSize(15.0f);
    }

    private void convertSearchMatchingList(RecyclerView.ViewHolder viewHolder, FaqListEntity faq) {
        try {
            ItemViewHolder holder = (ItemViewHolder)viewHolder;
            holder.ivTitle.setVisibility(8);
            holder.tvTitle.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
            holder.tvTitle.setTextSize(15.0f);
            String query = faq.getQuery();
            String sectionName = faq.getTitle();
            if (!TextUtils.isEmpty((CharSequence)query)) {
                String matchedWords = query.toLowerCase();
                String title = sectionName.toLowerCase();
                int highlightColor = Color.parseColor((String)CustomConfig.CommonSetting.highlightedColor);
                SpannableString spannedTitle = new SpannableString((CharSequence)sectionName);
                int index = TextUtils.indexOf((CharSequence)title, (CharSequence)matchedWords, (int)0);
                while (index >= 0) {
                    spannedTitle.setSpan((Object)new ForegroundColorSpan(highlightColor), index, Math.min(index + matchedWords.length(), title.length()), 33);
                    index = TextUtils.indexOf((CharSequence)title, (CharSequence)matchedWords, (int)(index + matchedWords.length()));
                }
                holder.tvTitle.setText((CharSequence)spannedTitle);
            } else {
                holder.tvTitle.setText((CharSequence)sectionName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.isGridLayout = recyclerView.getLayoutManager() instanceof GridLayoutManager;
    }

    public int getItemCount() {
        if (this.isFooterVisible) {
            return this.mDataSources.size() + 1;
        }
        return this.mDataSources.size();
    }

    public static class CSEntranceViewHolder
    extends RecyclerView.ViewHolder {
        AIHelpServiceEntrance csService;

        public CSEntranceViewHolder(@NonNull View itemView) {
            super(itemView);
            this.csService = (AIHelpServiceEntrance)itemView.findViewById(ResResolver.getViewId("aihelp_cs_entrance"));
        }
    }

    public static class ItemViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivTitle;
        TextView tvTitle;

        public ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            this.ivTitle = (ImageView)itemView.findViewById(ResResolver.getViewId("aihelp_iv_title"));
            this.tvTitle = (TextView)itemView.findViewById(ResResolver.getViewId("aihelp_tv_title"));
        }
    }
}

