/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.faq;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.CommonAdapter;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.ui.wrapper.FaqSelectedListenerWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class FaqListAdapter
extends CommonAdapter<FaqListEntity> {
    private FaqSelectedListenerWrapper mListener;

    public FaqListAdapter(Context context) {
        super(context);
    }

    @Override
    protected int itemLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_faq_linear_list");
    }

    @Override
    protected void convert(ViewHolder holder, final FaqListEntity faq, int position) {
        switch (faq.getDisplayType()) {
            case 1: {
                this.convertRootListView(holder, faq);
                break;
            }
            case 2: 
            case 3: {
                this.convertSubListView(holder, faq);
                break;
            }
            case 4: {
                this.convertSearchMatchingFaqTitles(holder, faq);
            }
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FaqListAdapter.this.mListener != null) {
                    switch (faq.getDisplayType()) {
                        case 1: 
                        case 2: {
                            FaqListAdapter.this.mListener.onIntentToSubSectionOrQuestionList(faq.getId(), faq.getTitle());
                            break;
                        }
                        case 3: 
                        case 4: {
                            FaqListAdapter.this.mListener.onIntentToQuestionContent(faq.getId(), faq.getQuery());
                        }
                    }
                }
            }
        });
    }

    private void convertRootListView(ViewHolder holder, FaqListEntity faq) {
        TextView tvTitle = (TextView)holder.getView(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, faq.getTitle());
    }

    private void convertSubListView(ViewHolder holder, FaqListEntity faq) {
        holder.setVisible(ResResolver.getViewId("aihelp_iv_title"), false);
        TextView tvTitle = (TextView)holder.getView(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, faq.getTitle());
    }

    private void convertSearchMatchingFaqTitles(ViewHolder holder, FaqListEntity faq) {
        try {
            holder.setVisible(ResResolver.getViewId("aihelp_iv_title"), false);
            TextView tvTitle = (TextView)holder.getView(ResResolver.getViewId("aihelp_tv_title"));
            tvTitle.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
            tvTitle.setTextSize(15.0f);
            String query = faq.getQuery();
            String sectionName = faq.getTitle();
            if (!TextUtils.isEmpty((CharSequence)query)) {
                String matchedWords = query.toLowerCase();
                String title = sectionName.toLowerCase();
                int highlightColor = Color.parseColor((String)CustomConfig.CommonSetting.highlightedColor);
                SpannableString spannedTitle = new SpannableString((CharSequence)sectionName);
                int index = TextUtils.indexOf((CharSequence)title, (CharSequence)matchedWords, (int)0);
                while (index >= 0) {
                    spannedTitle.setSpan((Object)new ForegroundColorSpan(highlightColor), index, Math.min(index + matchedWords.length(), title.length()), 33);
                    index = TextUtils.indexOf((CharSequence)title, (CharSequence)matchedWords, (int)(index + matchedWords.length()));
                }
                tvTitle.setText((CharSequence)spannedTitle);
            } else {
                tvTitle.setText((CharSequence)sectionName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnFaqSelectedListener(FaqSelectedListenerWrapper mListener) {
        this.mListener = mListener;
    }
}

