/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatButton;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.monitor.NetworkMonitor;
import net.aihelp.core.net.monitor.NetworkState;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.luban.Luban;
import net.aihelp.core.util.luban.OnCompressListener;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.event.PrepareMessageTimeStampEvent;
import net.aihelp.data.logic.ConversationPresenter;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.MessageListAdapter;
import net.aihelp.ui.cs.BaseCSFragment;
import net.aihelp.ui.helper.AttachmentPicker;
import net.aihelp.ui.helper.AttachmentPickerFile;
import net.aihelp.ui.helper.BitmapHelper;
import net.aihelp.ui.helper.ConversationHelper;
import net.aihelp.ui.helper.EvaluateNewHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.widget.AIHelpSwipeRefreshLayout;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;
import org.json.JSONArray;

public class ConversationFragment
extends BaseCSFragment<ConversationPresenter>
implements AttachmentPicker.AttachmentPickerListener {
    private boolean isModeConversation;
    private AIHelpSwipeRefreshLayout mRefreshLayout;
    private int mCurrentPage = 1;
    private boolean isTicketAlreadyFinished;
    private LinearLayout llInput;
    private LinearLayout llRate;

    public static ConversationFragment newInstance(Bundle bundle) {
        ConversationFragment fraConversation = new ConversationFragment();
        fraConversation.setArguments(bundle);
        return fraConversation;
    }

    @Override
    protected void initEventAndData(View contentView) {
        super.initEventAndData(contentView);
        this.llInput = (LinearLayout)this.get("aihelp_ll_input");
        this.llRate = (LinearLayout)this.get("aihelp_ll_rate");
        this.mRefreshLayout = (AIHelpSwipeRefreshLayout)((Object)this.get("aihelp_refresh_layout"));
        this.etInput.setText((CharSequence)((ConversationPresenter)this.mPresenter).getInputDraft());
        TextView rateInvite = (TextView)this.get("aihelp_tv_invite_rate");
        Styles.reRenderTextView(rateInvite, CustomConfig.CustomerService.csInviteEvaluate);
        AppCompatButton rateButton = (AppCompatButton)this.get("aihelp_btn_go_rate");
        rateButton.setText((CharSequence)ResResolver.getString("aihelp_rate_button"));
        rateButton.setBackground(Styles.getDrawable(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor), 8));
        this.mAdapter.setOnClickedListener(new MessageListAdapter.OnClickedListenerWrapper(){

            @Override
            public void onUrlClicked(String url) {
                if (((ConversationPresenter)ConversationFragment.this.mPresenter).validateNetwork()) {
                    Bundle bundle = new Bundle();
                    bundle.putString("intent_url", url);
                    EventBus.getDefault().post(new PageHoppingEvent(1009, bundle));
                }
            }

            @Override
            public void onRetrySendingMessage(int position, ConversationMsg msg) {
                if (!((ConversationPresenter)ConversationFragment.this.mPresenter).isNetworkAvailable() || !MqttConfig.getInstance().isConnected()) {
                    ToastUtil.INSTANCE.makeRawToast(ConversationFragment.this.getContext(), ResResolver.getString("aihelp_network_no_connect"));
                    return;
                }
                if (ConversationFragment.this.isTicketAlreadyFinished) {
                    ToastUtil.INSTANCE.makeRawToast(ConversationFragment.this.getContext(), ResResolver.getString("aihelp_ticket_closed"));
                    return;
                }
                ConversationFragment.this.mAdapter.remove(position);
                ConversationFragment.this.mAdapter.notifyItemChanged(position);
                if (msg.getMsgType() == 2) {
                    msg.setTimeStamp(System.currentTimeMillis());
                    ConversationFragment.this.updateChatList(msg);
                    ConversationFragment.this.chatWithSupportWithTimeout(msg.getTimeStamp(), msg.getMsgContent());
                }
                if (msg.getMsgType() == 6) {
                    ConversationFragment.this.uploadImage(msg.getMsgContent());
                }
                if (msg.getMsgType() == 7) {
                    ConversationFragment.this.uploadVideo(msg.getMsgContent());
                }
            }
        });
        this.mRefreshLayout.setEnabled(CustomConfig.CustomerService.isHistoryChatEnable);
        this.mRefreshLayout.setColorSchemeColors(Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));
        if (CustomConfig.CustomerService.isHistoryChatEnable) {
            this.mRefreshLayout.setOnRefreshListener(new AIHelpSwipeRefreshLayout.OnRefreshListener(){

                @Override
                public void onRefresh() {
                    ((ConversationPresenter)ConversationFragment.this.mPresenter).getLastConversation(ConversationFragment.this.mCurrentPage);
                }
            });
        }
        ImageView ivAttach = (ImageView)this.get("aihelp_iv_attach");
        ivAttach.setVisibility(0);
        ivAttach.setOnClickListener((View.OnClickListener)this);
        Styles.reRenderImageView(ivAttach, "aihelp_svg_ic_attach", true);
        this.get("aihelp_btn_go_rate").setOnClickListener((View.OnClickListener)this);
        ResponseMqttHelper.setHasUnreadMsg(false);
        if (!this.isOperateHuman) {
            ((ConversationPresenter)this.mPresenter).prepareMqttConnection(this.mqttCallback);
        }
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        this.isModeConversation = 2 == extras.getInt("support_mode");
    }

    @Override
    public void onResume() {
        super.onResume();
        if (!MqttConfig.getInstance().isConnected() && this.isOperateHuman) {
            ((ConversationPresenter)this.mPresenter).prepareMqttConnection(this.mqttCallback);
            return;
        }
        if (ResponseMqttHelper.isFormSubmitted()) {
            ResponseMqttHelper.setFormSubmitStatus(false);
            this.rvMsgList.scrollToPosition(this.mAdapter.getItemCount() - 1);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mPresenter != null && this.mAdapter != null) {
            ((ConversationPresenter)this.mPresenter).saveInputDraftIfNeeded(this.etInput.getText().toString().trim());
            if (this.isOperateHuman || this.isModeConversation) {
                ((ConversationPresenter)this.mPresenter).logoutMqtt(true);
            }
        }
        super.onDestroy();
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_conversation");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_conversation_root");
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        AIHelpPermissions.getInstance().onRequestPermissionsResult(grantResults.length == 1 && grantResults[0] == 0);
    }

    @Permission(requestCode=1000)
    public void launchPicker(Permission.Result result, final IPermissionCallback callback) {
        switch (result) {
            case GRANTED: {
                AttachmentPicker.getInstance().setPickerHost(this).launchImagePicker(true);
                break;
            }
            case DENIED: {
                ToastUtil.INSTANCE.showRawSnackBar((Activity)this.getActivity(), ResResolver.getString("aihelp_permission_denied"), 0);
                break;
            }
            case RATIONAL: {
                ToastUtil.INSTANCE.showRawSnackBar((Activity)this.getActivity(), ResResolver.getString("aihelp_permission_denied"), ResResolver.getString("aihelp_yes"), 0, new View.OnClickListener(){

                    public void onClick(View v) {
                        callback.onPermissionRational();
                    }
                });
                break;
            }
            case GO_SETTING: {
                ToastUtil.INSTANCE.showRawSnackBar((Activity)this.getActivity(), ResResolver.getString("aihelp_permission_ignored"), ResResolver.getString("aihelp_permission_settings"), 0, new View.OnClickListener(){

                    public void onClick(View v) {
                        callback.onPermissionIgnored();
                    }
                });
                break;
            }
            case NONE: {
                AttachmentPicker.getInstance().setPickerHost(this).launchImagePicker(false);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (intent != null && resultCode == -1) {
            AttachmentPicker.getInstance().onAttachmentPickRequestResult(requestCode, intent);
        }
    }

    private void chatWithSupportWithTimeout(long timeStamp, String input) {
        ((ConversationPresenter)this.mPresenter).chatWithSupport(timeStamp, input);
        this.sendDelayTimeoutMsg(timeStamp, 20L);
    }

    @Override
    public void onMqttLogin(List<ConversationMsg> mqttReplyMsg) {
        List<ConversationMsg> exceptionList;
        if (this.mAdapter.getItemCount() > 0 && !ListUtil.isListEmpty(exceptionList = this.getListIfDisconnectionEverHappened())) {
            mqttReplyMsg.addAll(exceptionList);
            Collections.sort(mqttReplyMsg, new Comparator<ConversationMsg>(){

                @Override
                public int compare(ConversationMsg o1, ConversationMsg o2) {
                    Long o1Time = o1.getTimeStamp();
                    Long o2Time = o2.getTimeStamp();
                    return o1Time.compareTo(o2Time);
                }
            });
            for (ConversationMsg msg : exceptionList) {
                if (msg.getMsgStatus() != 1001) continue;
                if (msg.getMsgType() == 6) {
                    ((ConversationPresenter)this.mPresenter).uploadImage(new File(msg.getMsgContent()), msg.getTimeStamp());
                    continue;
                }
                if (msg.getMsgType() == 7) {
                    ((ConversationPresenter)this.mPresenter).uploadVideo(new File(msg.getMsgContent()), msg.getTimeStamp());
                    continue;
                }
                this.chatWithSupportWithTimeout(msg.getTimeStamp(), msg.getMsgContent());
            }
        }
        this.mCurrentPage = 1;
        super.onMqttLogin(mqttReplyMsg);
        if (this.isVisible() && (ResponseMqttHelper.isTicketRejected() || ResponseMqttHelper.isTicketFinished())) {
            this.hideInputAfterConversationFinished();
        }
    }

    private List<ConversationMsg> getListIfDisconnectionEverHappened() {
        ArrayList<ConversationMsg> failedList = new ArrayList<ConversationMsg>();
        for (int i = this.mAdapter.getDataList().size() - 1; i >= 0; --i) {
            ConversationMsg msg = (ConversationMsg)this.mAdapter.getDataList().get(i);
            if (msg.getMsgStatus() == 1003) continue;
            failedList.add(0, msg);
        }
        return failedList;
    }

    public void hideInputAfterConversationFinished() {
        this.isTicketAlreadyFinished = true;
        this.llInput.postDelayed(new Runnable(){

            @Override
            public void run() {
                boolean ticketEvaluable;
                boolean bl = ticketEvaluable = ResponseMqttHelper.isTicketWaitForAskingResolveStatus() || ResponseMqttHelper.isTicketWaitForRating();
                if (ticketEvaluable && !ResponseMqttHelper.isTicketRejected()) {
                    ConversationFragment.this.llInput.setVisibility(8);
                    ConversationFragment.this.llRate.setVisibility(0);
                } else {
                    ConversationFragment.this.llInput.setVisibility(8);
                    ConversationFragment.this.llRate.setVisibility(8);
                }
            }
        }, 0L);
        SoftInputUtil.hideSoftInput(this.getContext(), (View)this.llInput);
    }

    @Override
    public void onPickSuccess(AttachmentPickerFile file, Bundle bundle) {
        if (this.isTicketAlreadyFinished) {
            return;
        }
        String path = file.filePath;
        if (TextUtils.isEmpty((CharSequence)path)) {
            ToastUtil.INSTANCE.makeText(this.getContext(), "Failed to get file path.", false);
            return;
        }
        if (Pattern.compile("^/.+\\.(png|jpg|jpeg|PNG|JPG|JPEG)$").matcher(path).matches()) {
            this.uploadImage(path);
        }
        if (Pattern.compile("^/.+\\.(mp4|MP4)$").matcher(path).matches()) {
            this.uploadVideo(path);
        }
    }

    private void uploadVideo(final String path) {
        MediaUtils.getImageForVideo(path, new MediaUtils.OnLoadVideoImageListener(){

            @Override
            public void onLoadImage(File file) {
                ConversationMsg videoMsg = new ConversationMsg(7, 1001);
                videoMsg.setMsgContent(path);
                ConversationFragment.this.updateChatList(videoMsg);
                ((ConversationPresenter)ConversationFragment.this.mPresenter).uploadVideo(new File(path), videoMsg.getTimeStamp());
                ConversationFragment.this.sendDelayTimeoutMsg(videoMsg.getTimeStamp(), 150L);
            }
        });
    }

    private void uploadImage(final String path) {
        Luban.with(this.getContext()).load(path).setCompressListener(new OnCompressListener(){

            @Override
            public void onStart() {
            }

            @Override
            public void onSuccess(File compressedFile) {
                this.uploadAfterCompress(compressedFile);
            }

            @Override
            public void onError(Throwable e) {
                this.uploadAfterCompress(new File(path));
            }

            private void uploadAfterCompress(File file) {
                ConversationMsg imageMsg = new ConversationMsg(6, 1001);
                imageMsg.setImageSize(BitmapHelper.computeSize(file.getPath()));
                imageMsg.setMsgContent(file.getPath());
                ConversationFragment.this.updateChatList(imageMsg);
                ((ConversationPresenter)ConversationFragment.this.mPresenter).uploadImage(file, imageMsg.getTimeStamp());
                ConversationFragment.this.sendDelayTimeoutMsg(imageMsg.getTimeStamp(), 50L);
            }
        }).launch();
    }

    @Override
    @SuppressLint(value={"StringFormatInvalid"})
    public void onPickFailure(int code, Long limitSize) {
        switch (code) {
            case -3: {
                String msg = ResResolver.getString("aihelp_media_upload_err_size");
                try {
                    ToastUtil.INSTANCE.makeRawToast(this.getContext(), String.format(msg, String.valueOf(limitSize / 0x100000L)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ToastUtil.INSTANCE.makeRawToast(this.getContext(), msg + ", < " + limitSize / 0x100000L + "M");
                }
                break;
            }
            case -5: {
                ToastUtil.INSTANCE.makeRawToast(this.getContext(), "Failed to get specific resource");
            }
        }
    }

    public void withdrawMsg(long withdrawTimeStamp) {
        for (int i = this.mAdapter.getDataList().size() - 1; i >= 0; --i) {
            ConversationMsg msg = (ConversationMsg)this.mAdapter.getDataList().get(i);
            if (msg.getTimeStamp() != withdrawTimeStamp) continue;
            this.mAdapter.getDataList().remove(i);
            this.mAdapter.notifyDataSetChanged();
            ((ConversationPresenter)this.mPresenter).updateCachedUnreadMessageCount(true);
            break;
        }
    }

    @Override
    @NetworkMonitor
    public void onNetworkStateChanged(NetworkState networkState) {
        if (networkState == NetworkState.NONE) {
            this.mqttCallback.onMqttFailure(null);
        } else if (this.isModeConversation) {
            ((ConversationPresenter)this.mPresenter).prepareMqttConnection(this.mqttCallback);
        }
    }

    public void onLastConversationRetrieved(List<ConversationMsg> msgList) {
        this.mRefreshLayout.setRefreshing(false);
        if (msgList != null) {
            ++this.mCurrentPage;
            this.mAdapter.insertHistoryConversation(msgList);
            RecyclerView.LayoutManager layoutManager = this.rvMsgList.getLayoutManager();
            if (layoutManager instanceof LinearLayoutManager) {
                LinearLayoutManager linearManager = (LinearLayoutManager)layoutManager;
                int lastItemPosition = linearManager.findLastVisibleItemPosition();
                this.rvMsgList.scrollToPosition(msgList.size() - 1 + lastItemPosition);
                this.rvMsgList.smoothScrollBy(0, -100);
            }
        }
    }

    public void onFormSubmitted(String formContent) {
        this.mAdapter.update(ConversationHelper.getUserFormMsgList(formContent), false);
        this.rvMsgList.scrollToPosition(this.mAdapter.getItemCount() - 1);
    }

    private void sendDelayTimeoutMsg(long timeStamp, long delaySeconds) {
        Message message = Message.obtain();
        message.obj = timeStamp;
        message.what = this.getMessageWhatFromTimeStamp(String.valueOf(timeStamp));
        this.mHandler.sendMessageDelayed(message, delaySeconds * 1000L);
    }

    @Override
    protected void handleMsg(Message msg) {
        this.updateMsgStatus(false, (Long)msg.obj);
    }

    private int getMessageWhatFromTimeStamp(String timeStamp) {
        return Integer.parseInt(timeStamp.substring(timeStamp.length() / 5 * 2));
    }

    public void updateMsgStatus(boolean isSuccess, long timeStamp) {
        this.mHandler.removeMessages(this.getMessageWhatFromTimeStamp(String.valueOf(timeStamp)));
        for (int i = this.mAdapter.getDataList().size() - 1; i >= 0; --i) {
            ConversationMsg msg = (ConversationMsg)this.mAdapter.getDataList().get(i);
            if (msg.getTimeStamp() != timeStamp) continue;
            msg.setMsgStatus(isSuccess ? 1003 : 1002);
            this.mAdapter.notifyItemChanged(i);
            break;
        }
    }

    @Override
    public void onEventComing(PrepareMessageTimeStampEvent event) {
        super.onEventComing(event);
        ((ConversationPresenter)this.mPresenter).updateCachedUnreadMessageCount(false);
    }

    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_btn_send") && ((ConversationPresenter)this.mPresenter).validateNetwork()) {
            StatisticHelper.whenSendButtonClicked();
            String input = this.etInput.getText().toString().trim();
            ((ConversationPresenter)this.mPresenter).clearInputDraft();
            ConversationMsg msg = ConversationHelper.getUserTextMsg(false, input);
            this.updateChatList(msg);
            this.chatWithSupportWithTimeout(msg.getTimeStamp(), input);
        }
        if (v.getId() == ResResolver.getViewId("aihelp_iv_attach") && ((ConversationPresenter)this.mPresenter).validateNetwork()) {
            AIHelpPermissions.getInstance().setHost(this).setRequestCode(1000).setRequestPermission(Build.VERSION.SDK_INT >= 16 ? "android.permission.READ_EXTERNAL_STORAGE" : "").request();
        }
        if (v.getId() == ResResolver.getViewId("aihelp_btn_go_rate")) {
            EvaluateNewHelper.getInstance().show(this.getContext(), new EvaluateNewHelper.OnConfirmEvaluateListener(){

                @Override
                public boolean onConfirmEvaluate(int rate, String input, JSONArray selected) {
                    if (!((ConversationPresenter)ConversationFragment.this.mPresenter).isNetworkAvailable() && !MqttConfig.getInstance().isConnected()) {
                        Toast.makeText((Context)ConversationFragment.this.getContext(), (CharSequence)ResResolver.getString("aihelp_network_no_connect"), (int)0).show();
                        return false;
                    }
                    ConversationFragment.this.bottomLayout.setVisibility(8);
                    if (ResponseMqttHelper.isTicketWaitForRating()) {
                        ((ConversationPresenter)ConversationFragment.this.mPresenter).evaluateSupport(rate, input, selected);
                    }
                    SpUtil.getInstance().put(UserProfile.USER_ID, 0);
                    ResponseMqttHelper.resetTicketStatusFlags();
                    ConversationFragment.this.mRefreshLayout.setEnabled(false);
                    return true;
                }
            });
        }
    }
}

