/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.faq;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.Iterator;
import java.util.List;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.data.logic.MqttCallbackImpl;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.ui.SupportFragment;
import net.aihelp.ui.faq.FaqSearchFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.helper.FragmentHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.widget.AIHelpServiceEntrance;
import net.aihelp.ui.wrapper.FaqEventListenerWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public abstract class BaseFaqFragment<T extends FaqPresenter>
extends BaseFragment<T>
implements View.OnClickListener {
    protected AIHelpServiceEntrance csEntrance;
    private String titleIcon;
    private String titleText;

    IFaqEventListener getFaqFlowListener() {
        SupportFragment supportFragment = FragmentHelper.getSupportFragment(this);
        if (supportFragment != null) {
            return supportFragment.getFaqEventListener();
        }
        return new FaqEventListenerWrapper();
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        this.titleIcon = extras.getString("section_icon");
        this.titleText = extras.getString("section_name");
        if (TextUtils.isEmpty((CharSequence)this.titleIcon)) {
            this.titleIcon = CustomConfig.HelpCenter.faqNavigationBarTitleIcon;
        }
        if (TextUtils.isEmpty((CharSequence)this.titleText)) {
            this.titleText = CustomConfig.HelpCenter.faqNavigationTitle;
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (Const.TOGGLE_OPEN_FAQ_NOTIFICATION) {
            MqttCallbackImpl.getInstance().updateHostView(this);
        }
        EventBus.getDefault().post(new SupportActionEvent(1002));
        EventBus.getDefault().post(new LoadingElvaEvent(1004));
        EventBus.getDefault().post(new UpdateTitleEvent(0, this.titleIcon, this.titleText));
        EventBus.getDefault().post(new SearchViewVisibilityChangeEvent(this instanceof FaqSearchFragment));
        this.csEntrance = (AIHelpServiceEntrance)((Object)this.get("aihelp_cs_entrance"));
        if (this.csEntrance != null) {
            this.csEntrance.setup(this.getMergedBundle(), this.getFaqFlowListener());
        }
    }

    Bundle getMergedBundle() {
        String[] excludedKeys;
        Bundle arguments = new Bundle(this.getArguments());
        block0: for (String excludedKey : excludedKeys = new String[]{"section_id", "sub_section_id", "section_icon", "faq_main_id"}) {
            Iterator iterator = arguments.keySet().iterator();
            while (iterator.hasNext()) {
                String bundleKey = (String)iterator.next();
                if (!excludedKey.equals(bundleKey)) continue;
                iterator.remove();
                break block0;
            }
        }
        return arguments;
    }

    public void refreshList(List<FaqListEntity> displayFaqList, String section) {
        this.refreshList(displayFaqList);
    }

    public void refreshList(List<FaqListEntity> displayFaqList) {
    }

    public void refreshQuestionContent(FaqContentEntity faq) {
    }

    void showSearchEmpty() {
        View layout = View.inflate((Context)this.getContext(), (int)ResResolver.getLayoutId("aihelp_layout_list_empty"), null);
        ImageView imageView = (ImageView)layout.findViewById(ResResolver.getViewId("aihelp_iv_empty"));
        TextView textView = (TextView)layout.findViewById(ResResolver.getViewId("aihelp_tv_empty"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_empty");
        Styles.reRenderTextView(textView, ResResolver.getString("aihelp_faq_search_empty"));
        super.showEmpty(layout);
    }

    @Override
    public void showEmpty(int ... layoutId) {
        View layout = View.inflate((Context)this.getContext(), (int)ResResolver.getLayoutId("aihelp_layout_list_empty"), null);
        ImageView imageView = (ImageView)layout.findViewById(ResResolver.getViewId("aihelp_iv_empty"));
        TextView textView = (TextView)layout.findViewById(ResResolver.getViewId("aihelp_tv_empty"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_empty");
        Styles.reRenderTextView(textView, ResResolver.getString("aihelp_data_not_found_msg"));
        super.showEmpty(layout);
    }

    public void showEntranceWithNotification(boolean hasUnreadMsg) {
        if (this.isVisible()) {
            if (hasUnreadMsg) {
                ResponseMqttHelper.setHasUnreadMsg(true);
            } else {
                ResponseMqttHelper.setTicketActive(true);
            }
            if (this.csEntrance != null) {
                this.csEntrance.updateViewVisibility(this.getMergedBundle());
            }
        }
    }

    public void onClick(View v) {
        Bundle bundle;
        if (v.getId() == ResResolver.getViewId("aihelp_cs_entrance") && (bundle = this.getArguments()) != null) {
            boolean skipElva = bundle.getBoolean("skip_elva_in_faq");
            if (skipElva) {
                bundle.putInt("support_mode", 2);
                this.getFaqFlowListener().onIntentToConversation(bundle);
            } else {
                this.getFaqFlowListener().onIntentToElvaBot(bundle);
            }
        }
    }
}

