/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.UUID;
import net.aihelp.config.AIHelpContext;
import net.aihelp.ui.helper.AttachmentPickerFile;

public class AttachmentHelper {
    public static final int PICK_IMAGE = 1;
    public static final int PICK_VIDEO = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachmentPickerFile createPickFileFromUri(Uri uri) {
        Context context = AIHelpContext.getInstance().getContext();
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(uri, null, null, null, null);
        Long size = null;
        String displayName = null;
        String mime = null;
        try {
            if (cursor != null && cursor.moveToFirst()) {
                String sizeString;
                int sizeIndex;
                displayName = cursor.getString(cursor.getColumnIndex("_display_name"));
                mime = contentResolver.getType(uri);
                if (TextUtils.isEmpty((CharSequence)displayName)) {
                    displayName = UUID.randomUUID().toString();
                }
                if (!cursor.isNull(sizeIndex = cursor.getColumnIndex("_size")) && (sizeString = cursor.getString(sizeIndex)) != null) {
                    try {
                        size = Long.valueOf(sizeString);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        AttachmentPickerFile attachmentPickerFile = new AttachmentPickerFile(uri, displayName, size);
        attachmentPickerFile.filePath = AttachmentHelper.copyAndGetFilePath(context, uri);
        attachmentPickerFile.isFileCompressionAndCopyingDone = attachmentPickerFile.filePath != null;
        attachmentPickerFile.attachmentType = mime != null && mime.startsWith("video/") ? 2 : 1;
        return attachmentPickerFile;
    }

    public static String copyAndGetFilePath(Context context, Uri uri) {
        try {
            File file;
            String displayName = UUID.randomUUID().toString();
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                displayName = cursor.getString(cursor.getColumnIndex("_display_name"));
            }
            if ((file = new File(context.getCacheDir(), displayName)).exists()) {
                return file.getPath();
            }
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            FileOutputStream outputStream = new FileOutputStream(file);
            int read = 0;
            byte[] buffers = new byte[8192];
            while ((read = inputStream.read(buffers)) != -1) {
                outputStream.write(buffers, 0, read);
            }
            if (cursor != null) {
                cursor.close();
            }
            inputStream.close();
            outputStream.close();
            return file.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

