/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.content.Context;
import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import net.aihelp.common.Const;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.parser.ElvaBotParser;
import net.aihelp.core.util.elva.util.Searcher;
import net.aihelp.core.util.elva.xml.XML;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.cs.storyline.BotFormUrl;
import net.aihelp.data.model.cs.storyline.BotOrderInfo;
import net.aihelp.data.model.cs.storyline.BotTag;
import net.aihelp.data.model.cs.storyline.BotUrl;
import net.aihelp.init.ConfigUtil;
import net.aihelp.ui.helper.LogoutMqttHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.utils.TLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ElvaBotHelper {
    private static ElvaBot sBotInstance;

    private ElvaBotHelper() {
    }

    public static void initBot(Context context) {
        ConfigUtil.prepareElvaBotConfigs(context);
        try {
            String rootPath = context.getFilesDir().getAbsolutePath();
            Searcher searcher = new Searcher();
            ElvaBotParser parser = new ElvaBotParser(Const.APP_ID, Const.CORRECT_LANGUAGE);
            FileInputStream contextInputStream = new FileInputStream(rootPath + "/AIHelp/bot/context.xml");
            FileInputStream splitterInputStream = new FileInputStream(rootPath + "/AIHelp/bot/splitters.xml");
            FileInputStream substitutionInputStream = new FileInputStream(rootPath + "/AIHelp/bot/substitutions.xml");
            sBotInstance = parser.parse(contextInputStream, (InputStream)splitterInputStream, (InputStream)substitutionInputStream, searcher.search(rootPath + "/AIHelp/AIML/" + Const.CORRECT_LANGUAGE, ".*\\.aiml"));
            contextInputStream.close();
            splitterInputStream.close();
            substitutionInputStream.close();
            if (sBotInstance != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                sBotInstance.getContext().outputStream(outputStream);
                outputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ElvaBotMsg getDefaultReply() {
        return ElvaBotHelper.getLocalReply("DEFAULTWELCOMETEXT");
    }

    public static ElvaBotMsg getLocalReply(String userInput) {
        ElvaBotMsg botMsg = new ElvaBotMsg();
        botMsg.setUserInput(userInput);
        if (ElvaBotHelper.isElvaPrepared()) {
            try {
                int i;
                JSONObject jsonObj = new JSONObject(XML.toJSONObject(sBotInstance.respondXml(userInput)).optString("msgs"));
                if (jsonObj.length() == 0) {
                    botMsg.setBotStupid(true);
                }
                if (jsonObj.has("msg")) {
                    String msg = jsonObj.optString("msg");
                    if (TextUtils.isEmpty((CharSequence)msg) || "null".equals(msg)) {
                        botMsg.setBotStupid(true);
                    } else {
                        botMsg.setBotMsg(msg);
                    }
                }
                if (jsonObj.has("actions")) {
                    ArrayList<String> actions = new ArrayList<String>();
                    JSONArray actionArray = JsonHelper.getJsonArray(JsonHelper.getJsonObject(jsonObj, "actions"), "action");
                    for (i = 0; i < actionArray.length(); ++i) {
                        JSONObject jsonObject = JsonHelper.getJsonObject(actionArray.getJSONObject(i), "action");
                        if (TextUtils.isEmpty((CharSequence)jsonObject.optString("reply"))) continue;
                        actions.add(jsonObject.optString("reply"));
                    }
                    botMsg.setActions(actions);
                }
                if (jsonObj.has("url")) {
                    String orderInfoJson;
                    JSONObject urlObj = JsonHelper.getJsonObject(jsonObj, "url");
                    String urlTitle = urlObj.optString("title");
                    String urlAddress = urlObj.optString("content");
                    if (!TextUtils.isEmpty((CharSequence)urlTitle) && !TextUtils.isEmpty((CharSequence)urlAddress)) {
                        botMsg.setBotUrl(new BotUrl(urlTitle, urlAddress));
                    }
                    if (urlObj.has("orderInfo") && !TextUtils.isEmpty((CharSequence)(orderInfoJson = urlObj.optString("orderInfo")))) {
                        JSONObject orderInfoObject = new JSONObject(orderInfoJson);
                        String id2 = orderInfoObject.optString("id");
                        String type = orderInfoObject.optString("type");
                        String name = orderInfoObject.optString("externalName");
                        String url = orderInfoObject.optString("interfaceUrl");
                        botMsg.setBotOrderInfo(new BotOrderInfo(id2, type, name, url));
                    }
                }
                if (jsonObj.has("url2")) {
                    JSONObject formUrlObj = JsonHelper.getJsonObject(jsonObj, "url2");
                    String formTitle = formUrlObj.optString("title");
                    String formAddress = formUrlObj.optString("formurl");
                    String formType = formUrlObj.optString("type");
                    botMsg.setBotFormUrl(new BotFormUrl(formTitle, formAddress, formType));
                }
                if (jsonObj.has("tags")) {
                    ArrayList<BotTag> botTags = new ArrayList<BotTag>();
                    JSONArray tagArray = JsonHelper.getJsonArray(JsonHelper.getJsonObject(jsonObj, "tags"), "tag");
                    for (i = 0; i < tagArray.length(); ++i) {
                        JSONObject jsonObject;
                        JSONObject obj = tagArray.getJSONObject(i);
                        if (!obj.has("tag") || TextUtils.isEmpty((CharSequence)(jsonObject = JsonHelper.getJsonObject(obj, "tag")).optString("name"))) continue;
                        botTags.add(new BotTag(jsonObject.optInt("id"), jsonObject.optString("name")));
                    }
                    botMsg.setBotTagList(botTags);
                }
                if (jsonObj.has("alicekm") && "wildcard".equals(JsonHelper.getJsonObject(jsonObj, "alicekm").optString("type"))) {
                    botMsg.setBotStupid(true);
                }
            }
            catch (Exception e) {
                botMsg.setBotStupid(true);
                TLog.e("ElvaBot getLocalReply() Exception -> " + e.toString());
                AIHelpLogger.error("ElvaBot getLocalReply exception", e);
            }
        } else {
            botMsg.setBotStupid(true);
        }
        return ElvaBotHelper.prepareRawResponseForMsg(botMsg);
    }

    private static boolean isElvaPrepared() {
        boolean prepared;
        boolean bl = prepared = sBotInstance != null;
        if (!prepared) {
            AIHelpLogger.error("isElvaPrepared", new UnknownError("sBotInstance == null"));
        }
        return prepared;
    }

    public static ConversationMsg getMqttReply(String response, boolean ... isWelcomeMsg) {
        ElvaBotMsg botMsg = new ElvaBotMsg();
        if (isWelcomeMsg.length == 0) {
            botMsg.setRawResponse(response);
        }
        try {
            int i;
            JSONObject jsonObj = new JSONObject(response);
            if (jsonObj.has("timeMillis")) {
                botMsg.setTimeStamp(jsonObj.getLong("timeMillis"));
            }
            if (jsonObj.has("msg")) {
                botMsg.setBotMsg(jsonObj.optString("msg"));
            }
            botMsg.setSimilarMatched(jsonObj.has("isSimilarMatch"));
            botMsg.setUserInput(jsonObj.optString("question"));
            if (jsonObj.has("actions")) {
                ArrayList<String> actions = new ArrayList<String>();
                JSONArray actionArray = JsonHelper.getJsonArray(jsonObj, "actions");
                for (i = 0; i < actionArray.length(); ++i) {
                    actions.add(actionArray.getJSONObject(i).optString("reply"));
                }
                botMsg.setActions(actions);
            }
            if (jsonObj.has("url")) {
                String orderInfoJson;
                JSONObject urlObj = JsonHelper.getJsonObject(jsonObj, "url");
                String urlTitle = urlObj.optString("title");
                String urlAddress = urlObj.optString("content");
                if (!TextUtils.isEmpty((CharSequence)urlTitle) && !TextUtils.isEmpty((CharSequence)urlAddress)) {
                    botMsg.setBotUrl(new BotUrl(urlTitle, urlAddress));
                }
                if (urlObj.has("orderInfo") && !TextUtils.isEmpty((CharSequence)(orderInfoJson = urlObj.optString("orderInfo")))) {
                    JSONObject orderInfoObject = new JSONObject(orderInfoJson);
                    String id2 = orderInfoObject.optString("id");
                    String type = orderInfoObject.optString("type");
                    String name = orderInfoObject.optString("externalName");
                    String url = orderInfoObject.optString("interfaceUrl");
                    botMsg.setBotOrderInfo(new BotOrderInfo(id2, type, name, url));
                }
            }
            if (jsonObj.has("url2")) {
                JSONObject formUrlObj = JsonHelper.getJsonObject(jsonObj, "url2");
                String formTitle = formUrlObj.optString("title");
                String formAddress = formUrlObj.optString("formurl");
                String formType = formUrlObj.optString("type");
                botMsg.setBotFormUrl(new BotFormUrl(formTitle, formAddress, formType));
                StatisticHelper.whenFormEventHappened(botMsg.getTimeStamp(), 1);
            }
            if (jsonObj.has("tags")) {
                ArrayList<BotTag> botTags = new ArrayList<BotTag>();
                JSONArray tagArray = JsonHelper.getJsonArray(jsonObj, "tags");
                for (i = 0; i < tagArray.length(); ++i) {
                    JSONObject obj = tagArray.getJSONObject(i);
                    if (obj.has("tag")) {
                        JSONObject jsonObject = JsonHelper.getJsonObject(obj, "tag");
                        botTags.add(new BotTag(jsonObject.optInt("id"), jsonObject.optString("name")));
                        continue;
                    }
                    if (!obj.has("id") || !obj.has("name")) continue;
                    botTags.add(new BotTag(obj.optInt("id"), obj.optString("name")));
                }
                botMsg.setBotTagList(botTags);
            }
            if (jsonObj.has("template")) {
                botMsg.setTemplate(jsonObj.optString("template"));
            }
            if (jsonObj.has("alicekm")) {
                JSONObject aliceObject = JsonHelper.getJsonObject(jsonObj, "alicekm");
                switch (aliceObject.optString("type")) {
                    case "faq": {
                        botMsg.setMsgType(5);
                        botMsg.setMsgStatus(100);
                        botMsg.setFaqMainId(aliceObject.optString("id"));
                        LogoutMqttHelper.updateType("5");
                        ElvaBotHelper.logElvaFAQViewed(botMsg);
                        break;
                    }
                    case "wildcard": {
                        botMsg.setBotStupid(true);
                        LogoutMqttHelper.updateType("3");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AIHelpLogger.error("ElvaBot getMqttReply exception", e);
        }
        return botMsg;
    }

    private static void logElvaFAQViewed(ElvaBotMsg botMsg) {
    }

    private static ElvaBotMsg prepareRawResponseForMsg(ElvaBotMsg botMsg) {
        if (botMsg.isBotStupid()) {
            botMsg.setRawResponse("");
            return botMsg;
        }
        JSONObject rawResponse = new JSONObject();
        try {
            rawResponse.put("timeMillis", botMsg.getTimeStamp());
            rawResponse.put("question", (Object)botMsg.getUserInput());
            rawResponse.put("msg", (Object)botMsg.getBotMsg());
            if (botMsg.isHasAction()) {
                JSONArray actions = new JSONArray();
                for (String actionName : botMsg.getActions()) {
                    JSONObject action = new JSONObject();
                    action.put("action", (Object)actionName);
                    action.put("reply", (Object)actionName);
                    actions.put((Object)action);
                }
                rawResponse.put("actions", (Object)actions);
            }
            if (botMsg.isHasUrl()) {
                JSONObject url = new JSONObject();
                url.put("title", (Object)botMsg.getBotUrl().getUrlTitle());
                url.put("content", (Object)botMsg.getBotUrl().getUrlAddress());
                if (botMsg.isHasOrderInfo()) {
                    JSONObject orderInfo = new JSONObject();
                    orderInfo.put("id", (Object)botMsg.getBotOrderInfo().getId());
                    orderInfo.put("type", (Object)botMsg.getBotOrderInfo().getType());
                    orderInfo.put("externalName", (Object)botMsg.getBotOrderInfo().getName());
                    orderInfo.put("interfaceUrl", (Object)botMsg.getBotOrderInfo().getUrl());
                    url.put("orderInfo", (Object)orderInfo.toString());
                }
                rawResponse.put("url", (Object)url);
            }
            if (botMsg.isHasFormUrl()) {
                JSONObject formUrl = new JSONObject();
                formUrl.put("title", (Object)botMsg.getBotFormUrl().getFormTitle());
                formUrl.put("formurl", (Object)botMsg.getBotFormUrl().getFormAddress());
                formUrl.put("type", (Object)botMsg.getBotFormUrl().getFormType());
                rawResponse.put("url2", (Object)formUrl);
            }
            if (botMsg.isHasTag()) {
                JSONArray tags = new JSONArray();
                for (BotTag botTag : botMsg.getBotTagList()) {
                    JSONObject tag = new JSONObject();
                    tag.put("id", botTag.getTagId());
                    tag.put("name", (Object)botTag.getTagName());
                    tags.put((Object)tag);
                }
                rawResponse.put("tags", (Object)tags);
            }
            botMsg.setRawResponse(rawResponse.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            AIHelpLogger.error("ElvaBot prepareRawResponseForMsg exception", e);
        }
        return botMsg;
    }
}

