/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.os.Build;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.common.API;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.localize.config.FeedbackOpinionHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.widget.AIHelpRatingBar;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import org.json.JSONArray;
import org.json.JSONObject;

public class EvaluateNewHelper {
    private AlertDialog rateSupportDialog;
    private LinearLayout llFeedbackLayout;
    private EditText etFeedback;
    private int selectedRateValue = 5;
    private final List<String> selectedOptionIds = new ArrayList<String>();
    private String inputFeedback = "";

    public static EvaluateNewHelper getInstance() {
        return new EvaluateNewHelper();
    }

    public void show(Context context, OnConfirmEvaluateListener listener) {
        if (ResponseMqttHelper.isTicketWaitForAskingResolveStatus()) {
            this.askAboutIssueResolvedStatus(context, listener, null);
        } else {
            this.showRateSupport(context, listener);
        }
    }

    public void askAboutIssueResolvedStatus(final Context context, final OnConfirmEvaluateListener listener, final OnConfirmResolveStatusListener resolveStatusListener) {
        final AlertDialog dialog = new AlertDialog.Builder(context).setContentView(ResResolver.getLayoutId("aihelp_dia_issue_solve_status")).setGravity(80).fromBottom(true).setCancelableOntheOutside(listener != null).setWidthAndHeight(-1, -2).create();
        RelativeLayout rlLayout = (RelativeLayout)dialog.getView(ResResolver.getViewId("aihelp_rl_issue_solve"));
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + 0.6, 0.8));
        rlLayout.setBackgroundColor(backgroundColor);
        TextView tvTitle = (TextView)dialog.getView(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, ResResolver.getString("aihelp_resolution_request"));
        AIHelpButton tvUnsolved = (AIHelpButton)((Object)dialog.getView(ResResolver.getViewId("aihelp_btn_unsolved")));
        tvUnsolved.setText(ResResolver.getString("aihelp_resolution_no"));
        tvUnsolved.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EvaluateNewHelper.this.onSolveStatusConfirmed(context, dialog, listener, resolveStatusListener, false);
            }
        });
        AIHelpButton tvSolved = (AIHelpButton)((Object)dialog.getView(ResResolver.getViewId("aihelp_btn_solved")));
        tvSolved.setText(ResResolver.getString("aihelp_resolution_yes"));
        tvSolved.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EvaluateNewHelper.this.onSolveStatusConfirmed(context, dialog, listener, resolveStatusListener, true);
            }
        });
        dialog.show();
    }

    private void onSolveStatusConfirmed(Context context, Dialog dialog, OnConfirmEvaluateListener listener, OnConfirmResolveStatusListener resolveStatusListener, boolean isResolved) {
        if (resolveStatusListener != null) {
            dialog.dismiss();
            resolveStatusListener.onConfirmResolve(isResolved);
            return;
        }
        if (AppInfoUtil.validateNetwork(context)) {
            try {
                dialog.dismiss();
                if (listener != null) {
                    JSONObject params = new JSONObject();
                    params.put("userId", (Object)UserProfile.USER_ID);
                    params.put("deviceId", (Object)DeviceUuidFactory.id(context));
                    params.put("resolveType", isResolved ? 1 : 2);
                    AIHelpRequest.getInstance().requestPostByJson(API.ASK_FOR_RESOLVE_STATUS, params, null);
                    ResponseMqttHelper.setTicketWaitForAskingResolveStatus(false);
                    if (ResponseMqttHelper.isTicketWaitForRating()) {
                        this.showRateSupport(context, listener);
                    } else {
                        this.onConfirmEvaluate(listener);
                        this.showThanksAfterEvaluate(context, false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showRateSupport(final Context context, final OnConfirmEvaluateListener listener) {
        this.rateSupportDialog = new AlertDialog.Builder(context).setContentView(ResResolver.getLayoutId("aihelp_dia_rate_support")).setGravity(80).fromBottom(true).setCancelableOntheOutside(true).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                EventBus.getDefault().unregister(EvaluateNewHelper.this);
            }
        }).fullWidth().create();
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + 0.6, 0.8));
        RelativeLayout rateLayout = (RelativeLayout)this.rateSupportDialog.getView(ResResolver.getViewId("aihelp_rl_rate_layout"));
        rateLayout.setBackgroundColor(backgroundColor);
        TextView tvTitle = (TextView)this.rateSupportDialog.getView(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, CustomConfig.CustomerService.csInviteEvaluate);
        TextView tvRatingDislike = (TextView)this.rateSupportDialog.getView(ResResolver.getViewId("aihelp_tv_rating_dislike"));
        Styles.reRenderTextView(tvRatingDislike, ResResolver.getString("aihelp_rate_dissatisfied"));
        TextView tvRatingLike = (TextView)this.rateSupportDialog.getView(ResResolver.getViewId("aihelp_tv_rating_like"));
        Styles.reRenderTextView(tvRatingLike, ResResolver.getString("aihelp_rate_satisfied"));
        this.llFeedbackLayout = (LinearLayout)this.rateSupportDialog.getView(ResResolver.getViewId("aihelp_ll_feedback"));
        final SparseArray<JSONArray> opinionArray = FeedbackOpinionHelper.INSTANCE.getOpinionArray();
        this.resetFeedbackOptions(context, (JSONArray)opinionArray.get(this.selectedRateValue));
        AIHelpRatingBar ratingBar = (AIHelpRatingBar)((Object)this.rateSupportDialog.getView(ResResolver.getViewId("aihelp_rating_bar")));
        if (ratingBar != null) {
            ratingBar.setOnStatusChangedListener(new AIHelpRatingBar.OnStatusChangedListener(){

                @Override
                public void onRateStatusChanged(int newRateValue) {
                    EvaluateNewHelper.this.selectedOptionIds.clear();
                    EvaluateNewHelper.this.selectedRateValue = newRateValue;
                    EvaluateNewHelper.this.resetFeedbackOptions(context, (JSONArray)opinionArray.get(newRateValue));
                }
            });
        }
        AIHelpButton btnConfirm = (AIHelpButton)((Object)this.rateSupportDialog.getView(ResResolver.getViewId("aihelp_btn_confirm")));
        btnConfirm.setText(ResResolver.getString("aihelp_yes")).setFullWidth();
        btnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(v.getContext())) {
                    EvaluateNewHelper.this.showThanksAfterEvaluate(context, EvaluateNewHelper.this.selectedRateValue == 5);
                    EvaluateNewHelper.this.rateSupportDialog.dismiss();
                    EvaluateNewHelper.this.onConfirmEvaluate(listener);
                }
            }
        });
        this.rateSupportDialog.show();
        EventBus.getDefault().register(this);
    }

    private void onConfirmEvaluate(OnConfirmEvaluateListener listener) {
        if (listener != null) {
            String input = "";
            if (this.etFeedback != null) {
                input = this.etFeedback.getText().toString();
            }
            try {
                JSONArray selectedOptions = new JSONArray();
                JSONArray options = (JSONArray)FeedbackOpinionHelper.INSTANCE.getOpinionArray().get(this.selectedRateValue);
                for (int i = 0; i < this.selectedOptionIds.size(); ++i) {
                    String id2 = this.selectedOptionIds.get(i);
                    for (int j = 0; j < options.length(); ++j) {
                        JSONObject object = JsonHelper.getJsonObject(options, j);
                        if (!id2.equals(JsonHelper.optString(object, "id"))) continue;
                        selectedOptions.put((Object)object);
                    }
                }
                listener.onConfirmEvaluate(this.selectedRateValue, input, selectedOptions);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void resetFeedbackOptions(Context context, JSONArray options) {
        if (CustomConfig.CustomerService.isEvaluateBadServiceEnable) {
            if (Styles.isLandscape()) {
                this.prepareFeedbackForLandscape(context, options);
            } else {
                this.prepareFeedbackForPortrait(context, options);
            }
        }
    }

    private void prepareFeedbackForPortrait(Context context, JSONArray options) {
        this.llFeedbackLayout.removeAllViews();
        if (options != null && options.length() > 0) {
            for (int i = 0; i < options.length(); ++i) {
                this.llFeedbackLayout.addView(this.getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i)));
            }
            this.prepareFeedbackInput(context);
        }
    }

    private void prepareFeedbackForLandscape(Context context, JSONArray options) {
        this.llFeedbackLayout.removeAllViews();
        if (options != null && options.length() > 0) {
            for (int i = 0; i < options.length(); i += 2) {
                View previousView = this.getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i));
                View afterwardsView = null;
                if (i + 1 < options.length()) {
                    afterwardsView = this.getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i + 1));
                }
                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(0);
                linearLayout.addView(previousView);
                if (afterwardsView != null) {
                    linearLayout.addView(afterwardsView);
                }
                this.llFeedbackLayout.addView((View)linearLayout);
            }
            this.prepareFeedbackInput(context);
        }
    }

    private void prepareFeedbackInput(Context context) {
        this.etFeedback = (EditText)View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_layout_feedback_input"), null);
        Styles.reRenderTextView((TextView)this.etFeedback, ResResolver.getString("aihelp_rate_additional_feedback_message"));
        if (!TextUtils.isEmpty((CharSequence)this.inputFeedback)) {
            this.etFeedback.setText((CharSequence)this.inputFeedback);
        }
        this.etFeedback.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, (double)0.1f), 8));
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.topMargin = Styles.dpToPx(context, 12.0f);
        this.etFeedback.setLayoutParams((ViewGroup.LayoutParams)params);
        this.llFeedbackLayout.addView((View)this.etFeedback);
    }

    private View getFeedbackOptionItem(final Context context, final JSONObject opinion) {
        CheckBox checkBox = (CheckBox)View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_layout_feedback_option"), null);
        String id2 = JsonHelper.optString(opinion, "id");
        String msg = JsonHelper.optString(opinion, "msg");
        Styles.reRenderTextView((TextView)checkBox, msg);
        for (int i = 0; i < this.selectedOptionIds.size(); ++i) {
            if (!id2.equals(this.selectedOptionIds.get(i))) continue;
            checkBox.setChecked(true);
            break;
        }
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    EvaluateNewHelper.this.selectedOptionIds.add(JsonHelper.optString(opinion, "id"));
                } else {
                    EvaluateNewHelper.this.selectedOptionIds.remove(JsonHelper.optString(opinion, "id"));
                }
                EvaluateNewHelper.this.updateCheckBoxEnableStatus(context);
            }
        });
        if (Build.VERSION.SDK_INT >= 21) {
            ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{-16842912}, {0x10100A0}}, new int[]{Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, (double)0.1f), Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor)});
            checkBox.setButtonTintList(colorStateList);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.weight = 1.0f;
        checkBox.setLayoutParams((ViewGroup.LayoutParams)params);
        return checkBox;
    }

    private void showThanksAfterEvaluate(final Context context, boolean isFiveStar) {
        final AlertDialog showThanksDialog = new AlertDialog.Builder(context).setContentView(ResResolver.getLayoutId("aihelp_dia_show_thanks")).setGravity(80).fromBottom(true).setCancelableOntheOutside(true).setWidthAndHeight(-1, -2).create();
        Object rlShowThanks = showThanksDialog.getView(ResResolver.getViewId("aihelp_rl_show_thanks"));
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + (double)0.6f, (double)0.8f));
        rlShowThanks.setBackgroundColor(backgroundColor);
        TextView tvTitle = (TextView)showThanksDialog.getView(ResResolver.getViewId("aihelp_tv_thanks"));
        Styles.reRenderTextView(tvTitle, ResResolver.getString("aihelp_rate_finished"));
        TextView tvCancel = (TextView)showThanksDialog.getView(ResResolver.getViewId("aihelp_tv_invite_rate"));
        Styles.reRenderTextView(tvCancel, ResResolver.getString("aihelp_rate_app_hint"), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.5));
        AIHelpButton tvRate = (AIHelpButton)((Object)showThanksDialog.getView(ResResolver.getViewId("aihelp_go_rate")));
        tvRate.setText(ResResolver.getString("aihelp_rate_button"));
        tvRate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppInfoUtil.goRateApp(context);
                showThanksDialog.dismiss();
            }
        });
        Object goRateLayout = showThanksDialog.getView(ResResolver.getViewId("aihelp_ll_go_rate"));
        goRateLayout.setVisibility(ResponseMqttHelper.isAppRatable() && isFiveStar ? 0 : 8);
        showThanksDialog.show();
    }

    private void updateCheckBoxEnableStatus(Context context) {
        int childCount = this.llFeedbackLayout.getChildCount();
        if (Styles.isLandscape()) {
            for (int i = 0; i < childCount; ++i) {
                View childView = this.llFeedbackLayout.getChildAt(i);
                if (!(childView instanceof LinearLayout)) continue;
                LinearLayout layout = (LinearLayout)childView;
                for (int j = 0; j < layout.getChildCount(); ++j) {
                    CheckBox checkBox;
                    View view = layout.getChildAt(j);
                    if (!(view instanceof CheckBox) || (checkBox = (CheckBox)view).isChecked()) continue;
                    checkBox.setEnabled(this.selectedOptionIds.size() < CustomConfig.CustomerService.csEvaluateMaxCount);
                }
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                CheckBox checkBox;
                View childView = this.llFeedbackLayout.getChildAt(i);
                if (!(childView instanceof CheckBox) || (checkBox = (CheckBox)childView).isChecked()) continue;
                checkBox.setEnabled(this.selectedOptionIds.size() < CustomConfig.CustomerService.csEvaluateMaxCount);
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(EventCenter event) {
        if (event instanceof OrientationChangeEvent && this.etFeedback != null) {
            this.inputFeedback = this.etFeedback.getText().toString();
            SparseArray<JSONArray> opinionArray = FeedbackOpinionHelper.INSTANCE.getOpinionArray();
            this.resetFeedbackOptions(this.etFeedback.getContext(), (JSONArray)opinionArray.get(this.selectedRateValue));
        }
    }

    public static interface OnConfirmResolveStatusListener {
        public void onConfirmResolve(boolean var1);
    }

    public static interface OnConfirmEvaluateListener {
        public boolean onConfirmEvaluate(int var1, String var2, JSONArray var3);
    }
}

