/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import java.util.List;
import net.aihelp.ui.SupportFragment;
import net.aihelp.utils.ResResolver;

public class FragmentHelper {
    public static void startFragment(FragmentManager fragmentManager, int fragmentContainerId, Fragment fragment, String tag, String backStackName, boolean executePendingTransactions, boolean disableAnimation) {
        FragmentHelper.loadFragment(fragmentManager, fragmentContainerId, fragment, tag, backStackName, executePendingTransactions, disableAnimation);
    }

    public static void startFragmentWithBackStack(FragmentManager fragmentManager, int fragmentContainerId, Fragment fragment, String tag, boolean executePendingTransactions) {
        FragmentHelper.loadFragment(fragmentManager, fragmentContainerId, fragment, tag, fragment.getClass().getName(), executePendingTransactions, false);
    }

    public static void startFragmentWithoutBackStack(FragmentManager fragmentManager, int fragmentContainerId, Fragment fragment, String tag, boolean executePendingTransactions) {
        FragmentHelper.loadFragment(fragmentManager, fragmentContainerId, fragment, tag, null, executePendingTransactions, false);
    }

    public static void popBackStack(FragmentManager fragmentManager, String backStackName) {
        fragmentManager.popBackStack(backStackName, 1);
    }

    public static void popBackStackImmediate(FragmentManager fragmentManager, String backStackName) {
        fragmentManager.popBackStackImmediate(backStackName, 1);
    }

    public static void removeFragment(FragmentManager fragmentManager, Fragment fragment) {
        fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
    }

    private static <T extends Fragment> T getFragment(FragmentManager fragmentManager, Class<T> c) {
        List fragments = fragmentManager.getFragments();
        for (Fragment fragment : fragments) {
            if (!c.isInstance(fragment)) continue;
            return (T)fragment;
        }
        return null;
    }

    public static SupportFragment getSupportFragment(Fragment fragment) {
        if (fragment instanceof SupportFragment) {
            return (SupportFragment)fragment;
        }
        if (fragment != null) {
            Fragment parentFragment = fragment.getParentFragment();
            if (parentFragment == null) {
                return null;
            }
            return parentFragment instanceof SupportFragment ? (SupportFragment)parentFragment : FragmentHelper.getSupportFragment(parentFragment);
        }
        return null;
    }

    private static void loadFragment(FragmentManager fragmentManager, int fragmentContainerId, Fragment fragment, String tag, String backStackName, boolean executePendingTransactions, boolean disableAnimation) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        Fragment previous = fragmentManager.findFragmentById(fragmentContainerId);
        if (previous != null && !disableAnimation) {
            fragmentTransaction.setCustomAnimations(ResResolver.getAnimId("aihelp_slide_in_from_right"), ResResolver.getAnimId("aihelp_slide_out_to_left"), ResResolver.getAnimId("aihelp_slide_in_from_left"), ResResolver.getAnimId("aihelp_slide_out_to_right"));
        } else {
            fragmentTransaction.setCustomAnimations(0, 0, 0, 0);
        }
        fragmentTransaction.replace(fragmentContainerId, fragment, tag);
        if (!TextUtils.isEmpty((CharSequence)backStackName)) {
            fragmentTransaction.addToBackStack(backStackName);
        }
        fragmentTransaction.commitAllowingStateLoss();
        if (executePendingTransactions) {
            fragmentManager.executePendingTransactions();
        }
    }

    @Nullable
    public static Fragment getTopMostFragment(FragmentManager fragmentManager) {
        Fragment topMostFragment = null;
        List activeFragments = fragmentManager.getFragments();
        if (activeFragments.size() > 0) {
            topMostFragment = (Fragment)activeFragments.get(activeFragments.size() - 1);
        }
        return topMostFragment;
    }
}

