/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.op;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import java.util.List;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.ui.loading.helper.VaryViewHelperController;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.OperatePagerEvent;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.model.op.OperateSection;
import net.aihelp.ui.adapter.OperateViewPagerAdapter;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.widget.tabs.TabLayout;
import net.aihelp.ui.widget.tabs.TabLayoutMediator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

public class OperationFragment
extends BaseFragment {
    private OperateViewPagerAdapter mAdapter;
    private boolean isContactUsAlwaysOnline;
    private int mCurrentItem;
    private String elvaTitle = ResResolver.getString("aihelp_op_cs");
    private View operateView;
    private boolean isNowInOperatePage;

    public static OperationFragment newInstance(Bundle bundle) {
        OperationFragment fraOperate = new OperationFragment();
        fraOperate.setArguments(bundle);
        return fraOperate;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StatisticHelper.whenOperationVisible();
    }

    @Override
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.operateView = inflater.inflate(ResResolver.getLayoutId("aihelp_fra_operate"), null);
        return this.operateView;
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_operate_root");
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        View targetView = view.findViewById(this.getLoadingTargetViewId());
        if (targetView != null) {
            this.mVaryViewHelperController = new VaryViewHelperController(targetView);
        }
        List<OperateSection> operateSectionList = OperateHelper.INSTANCE.getOperateSections();
        this.createOperateView(view, operateSectionList);
    }

    private void createOperateView(@NonNull View view, final List<OperateSection> operateSectionList) {
        final TabLayout tabLayout = (TabLayout)view.findViewById(ResResolver.getViewId("aihelp_tab"));
        tabLayout.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.navigationBarBackground, CustomConfig.CommonSetting.navigationBarAlpha));
        tabLayout.setVisibility(operateSectionList.size() == 0 ? 8 : 0);
        tabLayout.setSelectedTabIndicatorColor(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor));
        ViewPager2 viewPager = (ViewPager2)view.findViewById(ResResolver.getViewId("aihelp_view_pager"));
        if (this.getActivity() == null) {
            TLog.e("OperationFragment getActivity() returns null!");
            return;
        }
        this.mAdapter = new OperateViewPagerAdapter(this.getActivity(), this.getArguments(), operateSectionList);
        viewPager.setAdapter((RecyclerView.Adapter)this.mAdapter);
        final Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.isContactUsAlwaysOnline = this.getArguments().getBoolean("isContactUsAlwaysOnline");
            this.mCurrentItem = this.getArguments().getInt("operate_select_position");
            this.elvaTitle = this.getArguments().getString("operate_elva_title", ResResolver.getString("aihelp_op_cs"));
        }
        viewPager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback(){

            public void onPageSelected(int position) {
                Log.e((String)"TAG", (String)("position -------- " + position));
                EventBus.getDefault().post(new UpdateTitleEvent(1, CustomConfig.CustomerService.csNavigationBarTitleIcon, CustomConfig.CustomerService.csNavigationTitle));
                boolean isCurrentSectionAllRead = true;
                if (position < OperationFragment.this.mAdapter.getItemCount() - 1) {
                    String sectionId = ((OperateSection)operateSectionList.get(position)).getId();
                    isCurrentSectionAllRead = !OperateHelper.INSTANCE.isSectionUnread(sectionId);
                }
                for (int i = 0; i < tabLayout.getTabCount(); ++i) {
                    TabLayout.Tab tab = tabLayout.getTabAt(i);
                    if (tab == null || !(tab.getCustomView() instanceof RelativeLayout)) continue;
                    RelativeLayout customView = (RelativeLayout)tab.getCustomView();
                    ((TextView)customView.getChildAt(0)).setTypeface(tab.getPosition() == position ? Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
                    if (i != position || !isCurrentSectionAllRead) continue;
                    customView.getChildAt(1).setVisibility(8);
                }
                if (bundle != null) {
                    EventBus.getDefault().post(new OperatePagerEvent(position == OperationFragment.this.mAdapter.getItemCount() - 1));
                    if (position == OperationFragment.this.mAdapter.getItemCount() - 1) {
                        if (bundle.getBoolean("HUMAN_embedded_in_operation")) {
                            EventBus.getDefault().post(new SupportActionEvent(1002));
                        } else if (ResponseMqttHelper.isFormSubmitted()) {
                            EventBus.getDefault().post(new PageHoppingEvent(1008));
                        } else {
                            ResponseMqttHelper.updateElvaSupportActionStatus(OperationFragment.this.isContactUsAlwaysOnline);
                        }
                    } else {
                        EventBus.getDefault().post(new SupportActionEvent(1001, 1005));
                    }
                }
            }
        });
        TabLayoutMediator mediator = new TabLayoutMediator(tabLayout, viewPager, true, new TabLayoutMediator.TabConfigurationStrategy(){

            @Override
            public void onConfigureTab(@NonNull TabLayout.Tab tab, int position) {
                String secId;
                RelativeLayout tabViewLayout = new RelativeLayout(OperationFragment.this.getContext());
                tabViewLayout.setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-2, -1));
                TextView textView = new TextView(OperationFragment.this.getContext());
                RelativeLayout.LayoutParams textViewLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
                textViewLayoutParams.addRule(13);
                textView.setLayoutParams((ViewGroup.LayoutParams)textViewLayoutParams);
                int[][] states = new int[][]{{0x10100A1}, new int[0]};
                int[] colors = new int[]{Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor), Color.parseColor((String)CustomConfig.CommonSetting.textColor)};
                ColorStateList colorStateList = new ColorStateList((int[][])states, colors);
                String title = position == OperationFragment.this.mAdapter.getItemCount() - 1 ? OperationFragment.this.elvaTitle : ((OperateSection)operateSectionList.get(position)).getTitle();
                textView.setText((CharSequence)title);
                textView.setTextSize(15.0f);
                textView.setSingleLine();
                textView.setEllipsize(TextUtils.TruncateAt.END);
                textView.setTextColor(colorStateList);
                textView.setGravity(17);
                tabViewLayout.addView((View)textView);
                View unreadStatus = new View(OperationFragment.this.getContext());
                unreadStatus.setVisibility(8);
                RelativeLayout.LayoutParams notificationLayoutParams = new RelativeLayout.LayoutParams(OperationFragment.this.dip2px(OperationFragment.this.getContext(), 7.0), OperationFragment.this.dip2px(OperationFragment.this.getContext(), 7.0));
                notificationLayoutParams.addRule(11);
                notificationLayoutParams.rightMargin = OperationFragment.this.dip2px(OperationFragment.this.getContext(), 10.0);
                notificationLayoutParams.topMargin = OperationFragment.this.dip2px(OperationFragment.this.getContext(), 10.0);
                unreadStatus.setLayoutParams((ViewGroup.LayoutParams)notificationLayoutParams);
                unreadStatus.setBackgroundResource(ResResolver.getDrawableId("aihelp_bg_msg_unread"));
                tabViewLayout.addView(unreadStatus);
                if (Const.sOperationUnreadListener != null && position < OperationFragment.this.mAdapter.getItemCount() - 1 && OperateHelper.INSTANCE.isSectionUnread(secId = ((OperateSection)operateSectionList.get(position)).getId())) {
                    unreadStatus.setVisibility(0);
                }
                tab.setCustomView((View)tabViewLayout);
            }
        });
        mediator.attach();
        if (!this.isNowInOperatePage) {
            this.isNowInOperatePage = true;
            if (this.mCurrentItem >= this.mAdapter.getItemCount() - 1) {
                viewPager.setCurrentItem(this.mAdapter.getItemCount() - 1, false);
                EventBus.getDefault().post(new OperatePagerEvent(true));
                ResponseMqttHelper.updateElvaSupportActionStatus(this.isContactUsAlwaysOnline);
            } else {
                viewPager.setCurrentItem(this.mCurrentItem, false);
            }
        }
    }

    @Override
    protected void initEventAndData(View contentView) {
    }

    @Override
    protected int getLayout() {
        return 0;
    }

    public boolean onBackPressed() {
        if (this.mAdapter.getElvaBotFragment() != null) {
            return this.mAdapter.getElvaBotFragment().onBackPressed();
        }
        return true;
    }
}

