/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.animation.LayoutTransition;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.ui.image.TargetAdapter;
import net.aihelp.core.ui.loading.indicator.LoadingIndicatorView;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;

public class AIHelpLoadingImageView
extends FrameLayout {
    private AppCompatImageView imageView;
    private AppCompatImageView ivPlay;
    private View maskView;
    private LoadingIndicatorView loadingView;
    private boolean isVideo;
    private boolean isLoading;

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean loading) {
        this.isLoading = loading;
    }

    public AppCompatImageView getRealImageView() {
        return this.imageView;
    }

    public AIHelpLoadingImageView(@NonNull Context context) {
        super(context);
    }

    public AIHelpLoadingImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.getAttributes(context, attrs);
        this.init(context);
    }

    public AIHelpLoadingImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttributes(context, attrs);
        this.init(context);
    }

    private void getAttributes(Context context, AttributeSet attrs) {
        int[] styleable = ResResolver.getStyleable("aihelp_widget");
        if (styleable != null) {
            TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, styleable, 0, 0);
            this.isVideo = ta.getBoolean(ResResolver.getStyleableFieldIndex("aihelp_widget", "aihelp_widget_is_video"), false);
            ta.recycle();
        }
    }

    private void init(Context context) {
        this.setLayoutTransition(new LayoutTransition());
        this.setBackground(AppCompatResources.getDrawable((Context)context, (int)ResResolver.getDrawableId("aihelp_bg_uploading_mask")));
        this.setForegroundGravity(17);
        View rootView = AIHelpLoadingImageView.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_loading_image_view"), (ViewGroup)this);
        this.imageView = (AppCompatImageView)rootView.findViewById(ResResolver.getViewId("aihelp_image_view"));
        this.ivPlay = (AppCompatImageView)rootView.findViewById(ResResolver.getViewId("aihelp_iv_play"));
        this.maskView = rootView.findViewById(ResResolver.getViewId("aihelp_v_mask"));
        this.loadingView = (LoadingIndicatorView)rootView.findViewById(ResResolver.getViewId("aihelp_loading_view"));
        this.updateLoadingStatus(true);
    }

    public void updateLoadingStatus(boolean showLoading) {
        this.maskView.setVisibility(showLoading ? 0 : 8);
        this.loadingView.setVisibility(showLoading ? 0 : 8);
        if (this.isVideo) {
            this.ivPlay.setVisibility(showLoading ? 8 : 0);
        }
        this.setLoading(showLoading);
    }

    public void loadIntoImageView(Context context, final ConversationMsg conversationMsg) {
        if (context instanceof Activity && !((Activity)context).isFinishing()) {
            final String loadSource = DomainSupportHelper.getAdjustedUrl(this.isVideo ? conversationMsg.getVideoThumbnail() : conversationMsg.getMsgContent());
            if (conversationMsg.getMsgStatus() == 1003 && (this.isVideo || !conversationMsg.isMessageFromServer())) {
                this.updateLoadingStatus(false);
            }
            if (conversationMsg.getImageSize() != null) {
                ViewGroup.LayoutParams rootLayoutParams = this.getLayoutParams();
                ViewGroup.LayoutParams params = this.imageView.getLayoutParams();
                rootLayoutParams.width = params.width = conversationMsg.getImageSize()[0];
                rootLayoutParams.height = params.height = conversationMsg.getImageSize()[1];
                this.setLayoutParams(rootLayoutParams);
                this.imageView.setLayoutParams(params);
                Picasso.get().load(loadSource).fit().into((ImageView)this.imageView);
                return;
            }
            Picasso.get().load(loadSource).into(new TargetAdapter(){

                @Override
                public void onBitmapLoaded(Bitmap resource, Picasso.LoadedFrom from) {
                    TLog.e("onBitmapLoaded " + resource.getWidth() + ", " + resource.getHeight() + ", " + from.name());
                    if (conversationMsg.getImageSize() == null) {
                        int[] size = new int[2];
                        ViewGroup.LayoutParams params = AIHelpLoadingImageView.this.getLayoutParams();
                        float scale = (float)Math.max(resource.getWidth(), resource.getHeight()) / 700.0f;
                        if (scale < 1.0f) {
                            scale = 1.0f;
                        }
                        size[0] = params.width = Math.max(resource.getWidth() / (int)Math.ceil(scale), AIHelpLoadingImageView.this.dip2px(AIHelpLoadingImageView.this.getContext(), 50.0));
                        size[1] = params.height = Math.max(resource.getHeight() / (int)Math.ceil(scale), AIHelpLoadingImageView.this.dip2px(AIHelpLoadingImageView.this.getContext(), 50.0));
                        conversationMsg.setImageSize(size);
                        AIHelpLoadingImageView.this.setLayoutParams(params);
                    }
                    Picasso.get().load(loadSource).fit().into((ImageView)AIHelpLoadingImageView.this.imageView);
                    AIHelpLoadingImageView.this.updateLoadingStatus(false);
                }
            });
        }
    }

    public int dip2px(Context context, double dpValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * (double)density + 0.5);
    }

    public void showPlayButton(boolean show) {
        this.ivPlay.setVisibility(show ? 0 : 8);
    }
}

