/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;

public class AIHelpRoundImageView
extends AppCompatImageView {
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_BORDER_COLOR = 0;
    private static final int DEFAULT_FILL_COLOR = 0;
    private boolean roundDisable;
    private RoundMode roundMode = RoundMode.ROUND_DRAWABLE;
    private int borderColor = 0;
    private int borderWidth = 0;
    private int fillColor = 0;
    private Paint borderPaint;
    private Paint fillPaint;
    private Paint imagePaint;
    private Paint portPaint;
    private Rect bounds = new Rect();
    private float radius = 0.0f;
    private float cx = 0.0f;
    private float cy = 0.0f;

    public AIHelpRoundImageView(Context context) {
        super(context);
        this.initView();
    }

    public AIHelpRoundImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public AIHelpRoundImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.portPaint = new Paint();
        this.portPaint.setAntiAlias(true);
        this.borderPaint = new Paint();
        this.borderPaint.setAntiAlias(true);
        this.borderPaint.setColor(0);
        this.borderPaint.setStrokeWidth(0.0f);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.fillPaint = new Paint();
        this.fillPaint.setAntiAlias(true);
        this.fillPaint.setColor(0);
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.imagePaint = new Paint();
        this.imagePaint.setAntiAlias(true);
        this.imagePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
    }

    public void setRoundMode(RoundMode roundMode) {
        if (roundMode == null) {
            throw new IllegalArgumentException("roundMode is null.");
        }
        if (this.roundMode != roundMode) {
            this.roundMode = roundMode;
            this.invalidate();
        }
    }

    public void setRoundDisable(boolean roundDisable) {
        if (this.roundDisable != roundDisable) {
            this.roundDisable = roundDisable;
            this.invalidate();
        }
    }

    public boolean isRoundDisable() {
        return this.roundDisable;
    }

    public void setBorderColor(int borderColor) {
        if (this.borderColor != borderColor) {
            this.borderColor = borderColor;
            this.borderPaint.setColor(borderColor);
            this.invalidate();
        }
    }

    public void setBorderWidth(int borderWidth) {
        if (this.borderWidth != borderWidth) {
            this.borderWidth = borderWidth;
            this.borderPaint.setStrokeWidth((float)borderWidth);
            this.invalidate();
        }
    }

    public void setFillColor(int fillColor) {
        if (this.fillColor != fillColor) {
            this.fillColor = fillColor;
            this.fillPaint.setColor(fillColor);
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.roundDisable) {
            super.onDraw(canvas);
            return;
        }
        if (this.getDrawable() == null && this.roundMode == RoundMode.ROUND_DRAWABLE) {
            super.onDraw(canvas);
            return;
        }
        this.computeRoundBounds();
        this.drawCircle(canvas);
        this.drawImage(canvas);
    }

    @SuppressLint(value={"WrongCall"})
    private void drawImage(Canvas canvas) {
        Bitmap src = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        super.onDraw(new Canvas(src));
        Bitmap port = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas portCanvas = new Canvas(port);
        int saveCount = portCanvas.getSaveCount();
        portCanvas.save();
        this.adjustCanvas(portCanvas);
        portCanvas.drawCircle(this.cx, this.cy, this.radius, this.portPaint);
        portCanvas.restoreToCount(saveCount);
        portCanvas.drawBitmap(src, 0.0f, 0.0f, this.imagePaint);
        src.recycle();
        canvas.drawBitmap(port, 0.0f, 0.0f, null);
        port.recycle();
    }

    private void drawCircle(Canvas canvas) {
        int saveCount = canvas.getSaveCount();
        canvas.save();
        this.adjustCanvas(canvas);
        canvas.drawCircle(this.cx, this.cy, this.radius, this.fillPaint);
        if (this.borderWidth > 0) {
            canvas.drawCircle(this.cx, this.cy, this.radius - (float)this.borderWidth / 2.0f, this.borderPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    private void computeRoundBounds() {
        if (this.roundMode == RoundMode.ROUND_VIEW) {
            this.bounds.left = this.getPaddingLeft();
            this.bounds.top = this.getPaddingTop();
            this.bounds.right = this.getWidth() - this.getPaddingRight();
            this.bounds.bottom = this.getHeight() - this.getPaddingBottom();
        } else if (this.roundMode == RoundMode.ROUND_DRAWABLE) {
            this.getDrawable().copyBounds(this.bounds);
        } else {
            throw new RuntimeException("unknown round mode:" + (Object)((Object)this.roundMode));
        }
        this.radius = (float)Math.min(this.bounds.width(), this.bounds.height()) / 2.0f;
        this.cx = (float)this.bounds.left + (float)this.bounds.width() / 2.0f;
        this.cy = (float)this.bounds.top + (float)this.bounds.height() / 2.0f;
    }

    private void adjustCanvas(Canvas canvas) {
        if (this.roundMode == RoundMode.ROUND_DRAWABLE) {
            if (Build.VERSION.SDK_INT >= 16 && this.getCropToPadding()) {
                int scrollX = this.getScrollX();
                int scrollY = this.getScrollY();
                canvas.clipRect(scrollX + this.getPaddingLeft(), scrollY + this.getPaddingTop(), scrollX + this.getRight() - this.getLeft() - this.getPaddingRight(), scrollY + this.getBottom() - this.getTop() - this.getPaddingBottom());
            }
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            if (this.getImageMatrix() != null) {
                Matrix m = new Matrix(this.getImageMatrix());
                canvas.concat(m);
            }
        }
    }

    public static enum RoundMode {
        ROUND_VIEW,
        ROUND_DRAWABLE;

    }
}

