/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.text.TextUtils;
import java.util.Locale;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.config.enums.PublishCountryOrRegion;
import net.aihelp.utils.DeviceInfoUtil;

public class DomainSupportHelper {
    public static String getAdjustedUrl(String originUrl) {
        String adjustedDomain;
        if (!TextUtils.isEmpty((CharSequence)originUrl) && Const.countryOrRegion != null && !originUrl.contains(adjustedDomain = API.HOST_URL.substring(API.HOST_URL.indexOf(".") + 1))) {
            return originUrl.replace("aihelp.net", adjustedDomain);
        }
        return originUrl;
    }

    public static String getCorrectDomain(String domain) {
        if (!TextUtils.isEmpty((CharSequence)domain)) {
            String updatedDomain = domain.replace("https://", "").replace("http://", "");
            if (updatedDomain.endsWith("aihelp.net")) {
                if (Const.countryOrRegion == null) {
                    if (DomainSupportHelper.isSpecificCountryOrRegion("CN")) {
                        Const.countryOrRegion = PublishCountryOrRegion.CN;
                    } else if (DomainSupportHelper.isSpecificCountryOrRegion("IN")) {
                        Const.countryOrRegion = PublishCountryOrRegion.IN;
                    }
                }
                if (Const.countryOrRegion == PublishCountryOrRegion.CN) {
                    updatedDomain = updatedDomain + ".cn";
                } else if (Const.countryOrRegion == PublishCountryOrRegion.IN) {
                    updatedDomain = updatedDomain + ".in";
                }
            }
            return updatedDomain;
        }
        return "";
    }

    private static boolean isSpecificCountryOrRegion(String target) {
        if (!TextUtils.isEmpty((CharSequence)target)) {
            String country = Locale.getDefault().getCountry();
            String simCountryIso = DeviceInfoUtil.getInstance().getSimCountryIso();
            return target.equalsIgnoreCase(country) || target.equalsIgnoreCase(simCountryIso);
        }
        return false;
    }
}

