/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class KeyboardChangeHelper
implements ViewTreeObserver.OnGlobalLayoutListener {
    private View contentView;
    private EditText targetView;
    private int rootViewVisibleHeight = 0;
    private int offset;
    private OnKeyboardShowListener listener;

    public KeyboardChangeHelper(View contentView) {
        this.contentView = contentView;
        this.setTranslationOffset(0);
    }

    public void onGlobalLayout() {
        if (!this.initTargetView()) {
            return;
        }
        Rect r = new Rect();
        this.contentView.getWindowVisibleDisplayFrame(r);
        int visibleHeight = r.height();
        if (this.rootViewVisibleHeight == 0) {
            this.rootViewVisibleHeight = visibleHeight;
            return;
        }
        if (this.rootViewVisibleHeight == visibleHeight) {
            return;
        }
        if (this.rootViewVisibleHeight - visibleHeight > 200) {
            this.rootViewVisibleHeight = visibleHeight;
            if (null != this.listener) {
                this.listener.onKeyboardShow();
            }
            this.layoutResize(true, r.bottom);
            return;
        }
        if (visibleHeight - this.rootViewVisibleHeight > 200) {
            this.rootViewVisibleHeight = visibleHeight;
            if (null != this.listener) {
                this.listener.onKeyboardHide();
            }
            this.layoutResize(false, 0);
        }
    }

    private void layoutResize(boolean isKeyboardShow, int currentBottom) {
        int resizeHeight = 0;
        Rect rect = new Rect();
        if (null != this.targetView) {
            this.targetView.getGlobalVisibleRect(rect);
            resizeHeight = rect.bottom + this.offset - currentBottom;
        }
        if (resizeHeight < 0) {
            return;
        }
        if (isKeyboardShow) {
            this.contentView.setTranslationY((float)(-resizeHeight));
        } else {
            this.contentView.setTranslationY(0.0f);
        }
    }

    private boolean initTargetView() {
        Activity activity = (Activity)this.contentView.getContext();
        if (null == activity) {
            return false;
        }
        View focusedView = activity.getCurrentFocus();
        if (focusedView instanceof EditText) {
            this.targetView = (EditText)focusedView;
        }
        return true;
    }

    public void addListener() {
        this.contentView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    public void removeListener() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.contentView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    public void setTranslationOffset(int offset) {
        this.offset = offset;
    }

    public void addOnKeyboardShowListener(OnKeyboardShowListener listener) {
        this.listener = listener;
    }

    public static interface OnKeyboardShowListener {
        public void onKeyboardShow();

        public void onKeyboardHide();
    }
}

