/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.aihelp.config.AIHelpContext;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MediaUtils {
    public static final int MEDIA_TYPE_IMAGE = 1;
    public static final int MEDIA_TYPE_VIDEO = 2;
    public static File file;

    public static Uri getOutputMediaFileUri(Context context, int type) {
        Object uri = null;
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)context, (String)(context.getApplicationContext().getPackageName() + ".provider"), (File)MediaUtils.getOutputMediaFile(type));
        }
        return Uri.fromFile((File)MediaUtils.getOutputMediaFile(type));
    }

    public static File getOutputMediaFile(int type) {
        Context context = AIHelpContext.getInstance().getContext();
        if (context != null) {
            File mediaFile;
            File mediaStorageDir = new File(context.getExternalCacheDir() + "/aihelp/image");
            if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
                return null;
            }
            if (type == 1) {
                mediaFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + System.currentTimeMillis() + ".jpg");
            } else if (type == 2) {
                mediaFile = new File(mediaStorageDir.getPath() + File.separator + "VID_" + System.currentTimeMillis() + ".mp4");
            } else {
                return null;
            }
            file = mediaFile;
            return mediaFile;
        }
        return null;
    }

    public static void getImageForVideo(String videoPath, OnLoadVideoImageListener listener) {
        LoadVideoImageTask task = new LoadVideoImageTask(listener);
        task.execute(new String[]{videoPath});
    }

    public static interface OnLoadVideoImageListener {
        public void onLoadImage(File var1);
    }

    public static class LoadVideoImageTask
    extends AsyncTask<String, Integer, File> {
        private OnLoadVideoImageListener listener;

        public LoadVideoImageTask(OnLoadVideoImageListener listener) {
            this.listener = listener;
        }

        protected File doInBackground(String ... params) {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            String path = params[0];
            if (path.startsWith("http")) {
                mmr.setDataSource(path, new HashMap());
            } else {
                mmr.setDataSource(path);
            }
            Bitmap bitmap = mmr.getFrameAtTime();
            File f = MediaUtils.getOutputMediaFile(1);
            if (f != null && f.exists()) {
                f.delete();
            }
            try {
                FileOutputStream out = new FileOutputStream(f);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                mmr.release();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return f;
        }

        protected void onPostExecute(File file) {
            super.onPostExecute((Object)file);
            if (this.listener != null) {
                this.listener.onLoadImage(file);
            }
        }
    }
}

