/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.text.TextUtils;
import java.util.regex.Pattern;
import net.aihelp.exception.AIHelpInitException;

public class SchemaUtil {
    private static boolean validatePlatformId(String platformId) {
        return !TextUtils.isEmpty((CharSequence)platformId);
    }

    private static boolean validateDomainName(String domainName) {
        if (TextUtils.isEmpty((CharSequence)domainName)) {
            return false;
        }
        return Pattern.matches("^.+\\.(aihelp|aihelpcn).(net|online)$", domainName);
    }

    private static boolean validateApiKey(String apiKey) {
        return !TextUtils.isEmpty((CharSequence)apiKey);
    }

    public static void validateInitializeCredentials(Context context, String apiKey, String domainName, String platformId) throws IllegalArgumentException {
        if (context == null) {
            throw new AIHelpInitException("The application used in AIHelpSupport#init can't be null!");
        }
        if (!SchemaUtil.validateApiKey(apiKey)) {
            throw new AIHelpInitException("The appKey used in AIHelpSupport#init should not be empty!");
        }
        if (!SchemaUtil.validateDomainName(domainName)) {
            throw new AIHelpInitException("The domain used in AIHelpSupport#init should be exactly same as AIHelp Dashboard configuration.");
        }
        if (!SchemaUtil.validatePlatformId(platformId)) {
            throw new AIHelpInitException("The appId used in AIHelpSupport#init should not be empty!");
        }
    }
}

