/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.RestrictTo;
import java.util.WeakHashMap;
import net.aihelp.config.AIHelpContext;
import net.aihelp.ui.widget.snackbar.Snackbar;
import net.aihelp.utils.ResResolver;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public enum ToastUtil {
    INSTANCE;

    private Toast toast;
    private Snackbar snackbar;
    private final WeakHashMap<View, Snackbar> viewToSnackBarMapping = new WeakHashMap();

    public void makeRawToast(Context context, String text) {
        try {
            if (this.toast != null) {
                this.toast.setText((CharSequence)text);
            } else {
                this.toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)0);
            }
            this.toast.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void makeText(Context context, String text, boolean isLong) {
        try {
            View mView = LayoutInflater.from((Context)context).inflate(ResResolver.getLayoutId("aihelp_toast_center_view"), null);
            TextView textView = (TextView)mView.findViewById(ResResolver.getViewId("aihelp_toast_txt"));
            textView.setText((CharSequence)text);
            if (this.toast != null) {
                textView.setText((CharSequence)text);
            } else {
                this.toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)(isLong ? 1 : 0));
            }
            this.toast.setView(mView);
            this.toast.setGravity(17, 0, 0);
            this.toast.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showSnackBar(View view, String message, boolean isLong) {
        try {
            if (message != null && message.length() != 0) {
                if (view != null) {
                    this.snackbar = Snackbar.make(view, message, isLong ? 0 : -1);
                    this.snackbar.show();
                    this.viewToSnackBarMapping.put(view, this.snackbar);
                } else {
                    this.makeText(AIHelpContext.getInstance().getContext(), message, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void hideSnackBar(View view) {
        try {
            if (view != null) {
                Snackbar snackbar = this.viewToSnackBarMapping.get(view);
                if (snackbar != null && snackbar.isShown()) {
                    snackbar.dismiss();
                }
                this.viewToSnackBarMapping.remove(view);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showSnackBar(Activity activity, String message, boolean isLong) {
        try {
            if (this.snackbar != null && this.snackbar.isShown()) {
                return;
            }
            if (message != null && message.length() != 0) {
                Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(0x1020002), message, isLong ? 0 : -1);
                View snackBarView = snackbar.getView();
                snackBarView.setBackgroundColor(-1);
                ((TextView)snackBarView.findViewById(ResResolver.getViewId("snackbar_text"))).setTextColor(Color.parseColor((String)"#5C7EFF"));
                snackbar.setActionTextColor(Color.parseColor((String)"#5C7EFF"));
                snackbar.show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showSnackBar(Activity activity, String message, String action, View.OnClickListener listener) {
        try {
            if (message != null && message.length() != 0) {
                this.snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(0x1020002), message, 0).setAction(action, listener);
                View snackBarView = this.snackbar.getView();
                snackBarView.setBackgroundColor(Color.parseColor((String)"#EFF1F6"));
                ((TextView)snackBarView.findViewById(ResResolver.getViewId("snackbar_text"))).setTextColor(Color.parseColor((String)"#5C7EFF"));
                this.snackbar.setActionTextColor(Color.parseColor((String)"#5C7EFF"));
                this.snackbar.show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showRawSnackBar(Activity activity, String message, int duration) {
        try {
            if (message != null && message.length() != 0) {
                if (activity != null) {
                    View contentView = activity.getWindow().getDecorView().findViewById(0x1020002);
                    Snackbar.make(contentView, message, duration).show();
                } else {
                    this.makeText(AIHelpContext.getInstance().getContext(), message, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showRawSnackBar(Activity activity, String message, String action, int duration, View.OnClickListener listener) {
        try {
            if (message != null && message.length() != 0) {
                if (activity != null) {
                    View snackBarAction;
                    Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(0x1020002), message, duration).setAction(action, listener);
                    View snackBarText = snackbar.getView().findViewById(ResResolver.getViewId("snackbar_text"));
                    if (snackBarText instanceof TextView) {
                        ((TextView)snackbar.getView().findViewById(ResResolver.getViewId("snackbar_text"))).setMaxLines(4);
                    }
                    if ((snackBarAction = snackbar.getView().findViewById(ResResolver.getViewId("snackbar_action"))) instanceof TextView) {
                        ((TextView)snackbar.getView().findViewById(ResResolver.getViewId("snackbar_action"))).setTextColor(Color.parseColor((String)"#5C7EFF"));
                    }
                    snackbar.show();
                } else {
                    this.makeText(AIHelpContext.getInstance().getContext(), message, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

