package net.aihelp.config;

import net.aihelp.config.enums.ShowConversationMoment;

public class FaqConfig {

    private int showConversationMoment;
    private ConversationConfig conversationConfig;

    public static class Builder {

        private int showConversationMoment = ShowConversationMoment.NEVER.getValue();
        private ConversationConfig conversationConfig = new ConversationConfig.Builder().build();

        /**
         * Set show support moment in FAQ page.
         * <p>
         * User can access to support in several occasion, which are
         * {@link ShowConversationMoment#NEVER}, {@link ShowConversationMoment#ALWAYS},
         * {@link ShowConversationMoment#AFTER_MARKING_UNHELPFUL}
         *
         * @param showConversationMoment moment to show support button
         */
        public Builder setShowConversationMoment(ShowConversationMoment showConversationMoment) {
            this.showConversationMoment = showConversationMoment.getValue();
            return this;
        }

        /**
         * Set SupportConfig through FAQ
         * <p>
         * As user can get support via FAQ, you can configure support config here.
         *
         * @param conversationConfig supportConfig configure through FAQ
         * @see ConversationConfig for more infomation.
         */
        public Builder setConversationConfig(ConversationConfig conversationConfig) {
            if (conversationConfig != null) {
                this.conversationConfig = conversationConfig;
            }
            return this;
        }

        public FaqConfig build(int showSupportMoment, ConversationConfig conversationConfig) {
            return new FaqConfig(showSupportMoment, conversationConfig);
        }

        public FaqConfig build() {
            return new FaqConfig(showConversationMoment, conversationConfig);
        }
    }

    public int getShowConversationMoment() {
        return showConversationMoment;
    }

    public ConversationConfig getConversationConfig() {
        return conversationConfig;
    }

    private FaqConfig(int showConversationMoment, ConversationConfig conversationConfig) {
        this.showConversationMoment = showConversationMoment;
        this.conversationConfig = conversationConfig;
    }

    @Override
    public String toString() {
        return "FaqConfig{" +
                "showConversationMoment=" + showConversationMoment +
                ", supportConfig=" + conversationConfig +
                '}';
    }

}
