package net.aihelp.config.enums;

import net.aihelp.common.ConfigValues;

public enum ConversationIntent {

    BOT_SUPPORT(ConfigValues.INTENT_BOT_SUPPORT),
    HUMAN_SUPPORT(ConfigValues.INTENT_HUMAN_SUPPORT);

    private int value;

    ConversationIntent(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static ConversationIntent fromValue(int value) {
        switch (value) {
            case 1:
                return BOT_SUPPORT;
            case 2:
                return HUMAN_SUPPORT;
        }
        return null;
    }

}