package net.aihelp.config.enums;

import net.aihelp.common.ConfigValues;

public enum PushPlatform {

    APNS(ConfigValues.PUSH_PLATFORM_APNS),
    FIREBASE(ConfigValues.PUSH_PLATFORM_FIREBASE),
    JPUSH(ConfigValues.PUSH_PLATFORM_JPUSH),
    GETUI(ConfigValues.PUSH_PLATFORM_GETUI),
    HUAWEI(ConfigValues.PUSH_PLATFORM_HUAWEI),
    ONE_SIGNAL(ConfigValues.PUSH_PLATFORM_ONE_SIGNAL);

    private int value;

    PushPlatform(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static PushPlatform fromValue(int value) {
        switch (value) {
            case ConfigValues.PUSH_PLATFORM_APNS:
                return APNS;
            case ConfigValues.PUSH_PLATFORM_FIREBASE:
                return FIREBASE;
            case ConfigValues.PUSH_PLATFORM_JPUSH:
                return JPUSH;
            case ConfigValues.PUSH_PLATFORM_GETUI:
                return GETUI;
            case ConfigValues.PUSH_PLATFORM_HUAWEI:
                return HUAWEI;
            case ConfigValues.PUSH_PLATFORM_ONE_SIGNAL:
                return ONE_SIGNAL;
        }
        return null;
    }

}
