package net.aihelp.core.net.http.callback;

import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.TLog;

public abstract class UploadCallback<T> extends BaseCallback<T>{

    @Override
    public void onFailure(String url, int errorCode, String errorMsg) {
        TLog.d("UploadCallback onFailure: " + url + " : " + errorCode + " <-> " + errorMsg);
        if (onFailure(errorCode, errorMsg) || errorCode != 200) {
            if (AIHelpContext.getInstance().getContext() != null) {
                // ToastUtil.INSTANCE.makeText(AIHelpContext.getInstance().getContext(), errorMsg, false);
            }
        }
    }
    @Override
    public void onAsyncReqSuccess(T result) {

    }

    @Override
    public void onAsyncFailure(String url, int errorCode, String errorMsg) {

    }

    @Override
    public void onReqSuccess(T result) {

    }

    public boolean onFailure(int errorCode, String errorMsg) {
        return true;
    }

    @Override
    public void onReqProgress(long totalContentLength, long currentTransferred, int progress) {

    }

    @Override
    public void onAsyncReqProgress(long totalContentLength, long currentTransferred, int progress) {

    }
}
