package net.aihelp.core.net.mqtt.callback;

import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.utils.TLog;

import net.aihelp.core.net.mqtt.hawtbuf.Buffer;
import net.aihelp.core.net.mqtt.hawtbuf.UTF8Buffer;
import net.aihelp.core.net.mqtt.client.Listener;

public class ReceiveListener implements Listener {

    private final boolean isFaq;
    private final IMqttCallback callback;
    private final int connectionId;

    public ReceiveListener(boolean isFaq, IMqttCallback callback, int connectionId) {
        this.isFaq = isFaq;
        this.callback = callback;
        this.connectionId = connectionId;
    }

    @Override
    public void onConnected() {
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            callback.onMqttConnected();
        }
    }

    @Override
    public void onDisconnected() {
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            AIHelpMqtt.getInstance().disconnect();
            callback.onMqttDisconnected();
        }
    }

    @Override
    public void onPublish(UTF8Buffer utf8Buffer, Buffer body, Runnable ack) {
        // isFaq is not EXACTLY correct, there could be more than one faq mqtt connection
        // if user open and close faq pages really frequently, but related logic is only
        // the unread message notification, so just leave it for now.
        if (isFaq || this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            if (callback != null) {
                String[] topicArr = utf8Buffer.toString().split("/");
                final String topic = topicArr[topicArr.length - 1];
                String response = new String(body.toByteArray()).trim();

                TLog.json(String.format("MQTT %s [onResponse] %s",
                        this.toString().replace(this.getClass().getName(),
                                this.getClass().getSimpleName()), topic), response);
                final String finalResponse = response;
                ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        callback.onMqttResponse(topic, finalResponse);
                    }
                });
            }
            ack.run();
        }
    }

    @Override
    public void onFailure(final Throwable value) {
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            if (callback != null) {
                callback.onMqttFailure(value);
            }
        }
    }

}

