package net.aihelp.core.net.mqtt.hawtbuf.codec;

import net.aihelp.core.net.mqtt.hawtbuf.Buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/**
 * Implementation of a Codec for Buffer objects
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
abstract public class AbstractBufferCodec<T extends Buffer> extends VariableCodec<T> {

    public void encode(T value, DataOutput dataOut) throws IOException {
        dataOut.writeInt(value.length);
        dataOut.write(value.data, value.offset, value.length);
    }

    public T decode(DataInput dataIn) throws IOException {
        int size = dataIn.readInt();
        byte[] data = new byte[size];
        dataIn.readFully(data);
        return createBuffer(data);
    }

    abstract protected T createBuffer(byte [] data);

    public T deepCopy(T source) {
        return createBuffer(source.deepCopy().data);
    }

    public boolean isDeepCopySupported() {
        return true;
    }

    @Override
    public boolean isEstimatedSizeSupported() {
        return true;
    }

    public int estimatedSize(T object) {
        return object.length+4;
    }

}

