package net.aihelp.core.net.mqtt.hawtbuf.codec;

import net.aihelp.core.net.mqtt.hawtbuf.UTF8Buffer;

/**
 * Implementation of a Codec for UTF8Buffer objects.
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 *
 */
public class UTF8BufferCodec extends AbstractBufferCodec<UTF8Buffer> {
    public static final UTF8BufferCodec INSTANCE = new UTF8BufferCodec();

    @Override
    protected UTF8Buffer createBuffer(byte[] data) {
        return new UTF8Buffer(data);
    }

}
