package net.aihelp.core.net.mqtt.hawtdispatch;


/**
 * A dispatch source that is used to coalesce multiple application generated
 * events for later processing by the dispatch source event handler.
 *
 * @param <Event>
 * @param <MergedEvent>
 */
public interface CustomDispatchSource<Event, MergedEvent> extends DispatchSource {

    /**
     * <p>
     * Returns pending data for the dispatch source.  Calling this method consumes
     * the event and a subsequent call will return null.
     * </p><p>
     * This function is intended to be called from within the event handler runnable.
     * The result of calling this function outside of the event handler runnable is
     * undefined.
     * </p>
     *
     * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
     */
    public MergedEvent getData();

    /**
     * <p>
     * Merges data into a dispatch source and submits its event handler runnable to its
     * target queue.
     * </p>
     *
     * @param value
     * The value to coalesce with the pending data using the {@link EventAggregator}
     * that was specified when this dispach source was created.
     */
    public void merge(Event value);
}
