package net.aihelp.core.net.mqtt.hawtdispatch.internal;

import net.aihelp.core.net.mqtt.hawtdispatch.DispatchObject;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;

/**
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
abstract public class AbstractDispatchObject extends BaseSuspendable implements DispatchObject {

    protected volatile HawtDispatchQueue targetQueue;

    public void setTargetQueue(DispatchQueue next) {

        if( next!=targetQueue ) {
            // Don't see why someone would concurrently try to set the target..
            // IF we wanted to protect against that we would need to use cas operations here..
            DispatchQueue previous = this.targetQueue;
            this.targetQueue = (HawtDispatchQueue) next;
        }

    }

    public HawtDispatchQueue getTargetQueue() {
        return this.targetQueue;
    }

}
