package net.aihelp.core.net.mqtt.hawtdispatch.internal;


import net.aihelp.core.net.mqtt.hawtdispatch.Suspendable;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/**
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public class BaseSuspendable extends Task implements Suspendable {

    protected final AtomicBoolean startup = new AtomicBoolean(true);
    protected final AtomicInteger suspended = new AtomicInteger();

    public boolean isSuspended() {
        return suspended.get() > 0;
    }

    public void resume() {
        if (suspended.decrementAndGet() == 0) {
            if (startup.compareAndSet(true, false)) {
                onStartup();
            } else {
                onResume();
            }
        }
    }

    public void suspend() {
        if (suspended.getAndIncrement() == 0) {
            onSuspend();
        }
    }

    protected void onStartup() {
    }

    protected void onSuspend() {
    }

    protected void onResume() {
    }

    @Override
    public void run() {
    }
}
