package net.aihelp.core.net.mqtt.hawtdispatch.internal.util;

import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.TaskWrapper;

import java.util.concurrent.CountDownLatch;

/**
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public class QueueSupport {

    static public void dispatchApply(DispatchQueue queue, int iterations, final Runnable runnable) throws InterruptedException {
        dispatchApply(queue, iterations, new TaskWrapper(runnable));
    }

    static public void dispatchApply(DispatchQueue queue, int iterations, final Task task) throws InterruptedException {
        final CountDownLatch done = new CountDownLatch(iterations);
        Task wrapper = new Task() {
            public void run() {
                try {
                    task.run();
                } finally {
                    done.countDown();
                }
            }
        };
        for( int i=0; i < iterations; i++ ) {
            queue.execute(wrapper);
        }
        done.await();
    }

}