package net.aihelp.core.net.mqtt.tansport;


import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public class PipeTransportRegistry {

    public static final HashMap<String, PipeTransportServer> servers = new HashMap<String, PipeTransportServer>();

    synchronized static public TransportServer bind(String location) throws URISyntaxException, IOException {
        if (servers.containsKey(location)) {
            throw new IOException("Server already bound: " + location);
        }
        PipeTransportServer server = new PipeTransportServer();
        server.setConnectURI(location);
        server.setName(location);
        servers.put(location, server);
        return server;
    }

    synchronized static public Transport connect(String location) throws IOException, URISyntaxException {
        PipeTransportServer server = lookup(location);
        if (server == null) {
            throw new IOException("Server is not bound: " + location);
        }
        return server.connect();
    }

    synchronized static public PipeTransportServer lookup(String name) {
        return servers.get(name);
    }

    synchronized static public Map<String, PipeTransportServer> getServers() {
        return new HashMap<String, PipeTransportServer>(servers);
    }

    synchronized static public void unbind(PipeTransportServer server) {
        servers.remove(server.getName());
    }
}