package net.aihelp.core.net.mqtt.tansport;

import java.io.IOException;

/**
 * An asynchronous listener of commands
 *
 */
public interface TransportListener {

    /**
     * called to process a command
     * @param command
     */
    void onTransportCommand(Object command);

    /**
     * transport can now accept more commands for transmission.
     */
    void onRefill();

    /**
     * An unrecoverable exception has occured on the transport
     * @param error
     */
    void onTransportFailure(IOException error);

    /**
     * The transport has been connected.
     */
    public void onTransportConnected();

    /**
     * The transport has been disconnected.
     */
    public void onTransportDisconnected();

}