package net.aihelp.core.ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public enum ActivityManager {

    INSTANCE;

    private final List<WeakReference<BaseActivity>> sActivityList = new ArrayList<>();

    public void register(BaseActivity activity) {
        sActivityList.add(new WeakReference<>(activity));
    }

    public void unregister(BaseActivity activity) {
        Iterator<WeakReference<BaseActivity>> iterator = sActivityList.iterator();
        while (iterator.hasNext()) {
            WeakReference<BaseActivity> activityRef = iterator.next();
            if (activityRef != null && activityRef.get() != null) {
                BaseActivity baseActivity = activityRef.get();
                if (baseActivity == activity) {
                    iterator.remove();
                }
            }
        }
    }

    public void finishAll() {
        for (int i = sActivityList.size() - 1; i >= 0; i--) {
            WeakReference<BaseActivity> activityRef = sActivityList.get(i);
            if (activityRef != null && activityRef.get() != null) {
                activityRef.get().finish();
            }
        }
    }

}
