package net.aihelp.core.ui.glide.load.resource.bitmap;

import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.BitmapPool;
import net.aihelp.core.ui.glide.load.resource.drawable.DrawableResource;
import net.aihelp.core.ui.glide.util.Util;

/**
 * A resource wrapper for {@link net.aihelp.core.ui.glide.load.resource.bitmap.GlideBitmapDrawable}.
 */
public class GlideBitmapDrawableResource extends DrawableResource<GlideBitmapDrawable> {
    private final BitmapPool bitmapPool;

    public GlideBitmapDrawableResource(GlideBitmapDrawable drawable, BitmapPool bitmapPool) {
        super(drawable);
        this.bitmapPool = bitmapPool;
    }

    @Override
    public int getSize() {
        return Util.getBitmapByteSize(drawable.getBitmap());
    }

    @Override
    public void recycle() {
        bitmapPool.put(drawable.getBitmap());
    }
}
