package net.aihelp.core.ui.glide.load.resource.gif;

import net.aihelp.core.ui.glide.load.resource.drawable.DrawableResource;
import net.aihelp.core.ui.glide.util.Util;

/**
 * A resource wrapping an {@link net.aihelp.core.ui.glide.load.resource.gif.GifDrawable}.
 */
public class GifDrawableResource extends DrawableResource<GifDrawable> {
    public GifDrawableResource(GifDrawable drawable) {
        super(drawable);
    }

    @Override
    public int getSize() {
        return drawable.getData().length + Util.getBitmapByteSize(drawable.getFirstFrame());
    }

    @Override
    public void recycle() {
        drawable.stop();
        drawable.recycle();
    }
}
